/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.MetadataKeyValuePair;
import software.amazon.awssdk.services.glue.model.MetadataListCopier;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.services.glue.model.SchemaVersionNumber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuerySchemaVersionMetadataRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, QuerySchemaVersionMetadataRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(QuerySchemaVersionMetadataRequest.getter(QuerySchemaVersionMetadataRequest::schemaId)).setter(QuerySchemaVersionMetadataRequest.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<SchemaVersionNumber> SCHEMA_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaVersionNumber").getter(QuerySchemaVersionMetadataRequest.getter(QuerySchemaVersionMetadataRequest::schemaVersionNumber)).setter(QuerySchemaVersionMetadataRequest.setter(Builder::schemaVersionNumber)).constructor(SchemaVersionNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(QuerySchemaVersionMetadataRequest.getter(QuerySchemaVersionMetadataRequest::schemaVersionId)).setter(QuerySchemaVersionMetadataRequest.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<List<MetadataKeyValuePair>> METADATA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetadataList").getter(QuerySchemaVersionMetadataRequest.getter(QuerySchemaVersionMetadataRequest::metadataList)).setter(QuerySchemaVersionMetadataRequest.setter(Builder::metadataList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataKeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(QuerySchemaVersionMetadataRequest.getter(QuerySchemaVersionMetadataRequest::maxResults)).setter(QuerySchemaVersionMetadataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QuerySchemaVersionMetadataRequest.getter(QuerySchemaVersionMetadataRequest::nextToken)).setter(QuerySchemaVersionMetadataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, SCHEMA_VERSION_NUMBER_FIELD, SCHEMA_VERSION_ID_FIELD, METADATA_LIST_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final SchemaId schemaId;
    private final SchemaVersionNumber schemaVersionNumber;
    private final String schemaVersionId;
    private final List<MetadataKeyValuePair> metadataList;
    private final Integer maxResults;
    private final String nextToken;

    private QuerySchemaVersionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
        this.schemaVersionId = builder.schemaVersionId;
        this.metadataList = builder.metadataList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final SchemaId schemaId() {
        return this.schemaId;
    }

    public final SchemaVersionNumber schemaVersionNumber() {
        return this.schemaVersionNumber;
    }

    public final String schemaVersionId() {
        return this.schemaVersionId;
    }

    public final boolean hasMetadataList() {
        return this.metadataList != null && !(this.metadataList instanceof SdkAutoConstructList);
    }

    public final List<MetadataKeyValuePair> metadataList() {
        return this.metadataList;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataList() ? this.metadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySchemaVersionMetadataRequest)) {
            return false;
        }
        QuerySchemaVersionMetadataRequest other = (QuerySchemaVersionMetadataRequest)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.schemaVersionNumber(), other.schemaVersionNumber()) && Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && this.hasMetadataList() == other.hasMetadataList() && Objects.equals(this.metadataList(), other.metadataList()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"QuerySchemaVersionMetadataRequest").add("SchemaId", (Object)this.schemaId()).add("SchemaVersionNumber", (Object)this.schemaVersionNumber()).add("SchemaVersionId", (Object)this.schemaVersionId()).add("MetadataList", this.hasMetadataList() ? this.metadataList() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "SchemaVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionNumber()));
            }
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "MetadataList": {
                return Optional.ofNullable(clazz.cast(this.metadataList()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuerySchemaVersionMetadataRequest, T> g) {
        return obj -> g.apply((QuerySchemaVersionMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private SchemaVersionNumber schemaVersionNumber;
        private String schemaVersionId;
        private List<MetadataKeyValuePair> metadataList = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySchemaVersionMetadataRequest model) {
            super(model);
            this.schemaId(model.schemaId);
            this.schemaVersionNumber(model.schemaVersionNumber);
            this.schemaVersionId(model.schemaVersionId);
            this.metadataList(model.metadataList);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final SchemaVersionNumber.Builder getSchemaVersionNumber() {
            return this.schemaVersionNumber != null ? this.schemaVersionNumber.toBuilder() : null;
        }

        public final void setSchemaVersionNumber(SchemaVersionNumber.BuilderImpl schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber != null ? schemaVersionNumber.build() : null;
        }

        @Override
        public final Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final List<MetadataKeyValuePair.Builder> getMetadataList() {
            List<MetadataKeyValuePair.Builder> result = MetadataListCopier.copyToBuilder(this.metadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataList(Collection<MetadataKeyValuePair.BuilderImpl> metadataList) {
            this.metadataList = MetadataListCopier.copyFromBuilder(metadataList);
        }

        @Override
        public final Builder metadataList(Collection<MetadataKeyValuePair> metadataList) {
            this.metadataList = MetadataListCopier.copy(metadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataList(MetadataKeyValuePair ... metadataList) {
            this.metadataList(Arrays.asList(metadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataList(Consumer<MetadataKeyValuePair.Builder> ... metadataList) {
            this.metadataList(Stream.of(metadataList).map(c -> (MetadataKeyValuePair)((MetadataKeyValuePair.Builder)MetadataKeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QuerySchemaVersionMetadataRequest build() {
            return new QuerySchemaVersionMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QuerySchemaVersionMetadataRequest> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder schemaVersionNumber(SchemaVersionNumber var1);

        default public Builder schemaVersionNumber(Consumer<SchemaVersionNumber.Builder> schemaVersionNumber) {
            return this.schemaVersionNumber((SchemaVersionNumber)((SchemaVersionNumber.Builder)SchemaVersionNumber.builder().applyMutation(schemaVersionNumber)).build());
        }

        public Builder schemaVersionId(String var1);

        public Builder metadataList(Collection<MetadataKeyValuePair> var1);

        public Builder metadataList(MetadataKeyValuePair ... var1);

        public Builder metadataList(Consumer<MetadataKeyValuePair.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

