/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsRequest;
import software.amazon.awssdk.services.glue.model.GetWorkflowRunsResponse;

public class GetWorkflowRunsPublisher
implements SdkPublisher<GetWorkflowRunsResponse> {
    private final GlueAsyncClient client;
    private final GetWorkflowRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetWorkflowRunsPublisher(GlueAsyncClient client, GetWorkflowRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetWorkflowRunsPublisher(GlueAsyncClient client, GetWorkflowRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetWorkflowRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetWorkflowRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetWorkflowRunsResponseFetcher
    implements AsyncPageFetcher<GetWorkflowRunsResponse> {
        private GetWorkflowRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetWorkflowRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetWorkflowRunsResponse> nextPage(GetWorkflowRunsResponse previousPage) {
            if (previousPage == null) {
                return GetWorkflowRunsPublisher.this.client.getWorkflowRuns(GetWorkflowRunsPublisher.this.firstRequest);
            }
            return GetWorkflowRunsPublisher.this.client.getWorkflowRuns((GetWorkflowRunsRequest)((Object)GetWorkflowRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

