/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.Action;
import software.amazon.awssdk.services.glue.model.ActionListCopier;
import software.amazon.awssdk.services.glue.model.EventBatchingCondition;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Predicate;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.services.glue.model.TriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTriggerRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateTriggerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateTriggerRequest.getter(CreateTriggerRequest::name)).setter(CreateTriggerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> WORKFLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowName").getter(CreateTriggerRequest.getter(CreateTriggerRequest::workflowName)).setter(CreateTriggerRequest.setter(Builder::workflowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateTriggerRequest.getter(CreateTriggerRequest::typeAsString)).setter(CreateTriggerRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(CreateTriggerRequest.getter(CreateTriggerRequest::schedule)).setter(CreateTriggerRequest.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Predicate").getter(CreateTriggerRequest.getter(CreateTriggerRequest::predicate)).setter(CreateTriggerRequest.setter(Builder::predicate)).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()}).build();
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(CreateTriggerRequest.getter(CreateTriggerRequest::actions)).setter(CreateTriggerRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateTriggerRequest.getter(CreateTriggerRequest::description)).setter(CreateTriggerRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> START_ON_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StartOnCreation").getter(CreateTriggerRequest.getter(CreateTriggerRequest::startOnCreation)).setter(CreateTriggerRequest.setter(Builder::startOnCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartOnCreation").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateTriggerRequest.getter(CreateTriggerRequest::tags)).setter(CreateTriggerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EventBatchingCondition> EVENT_BATCHING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventBatchingCondition").getter(CreateTriggerRequest.getter(CreateTriggerRequest::eventBatchingCondition)).setter(CreateTriggerRequest.setter(Builder::eventBatchingCondition)).constructor(EventBatchingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBatchingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, WORKFLOW_NAME_FIELD, TYPE_FIELD, SCHEDULE_FIELD, PREDICATE_FIELD, ACTIONS_FIELD, DESCRIPTION_FIELD, START_ON_CREATION_FIELD, TAGS_FIELD, EVENT_BATCHING_CONDITION_FIELD));
    private final String name;
    private final String workflowName;
    private final String type;
    private final String schedule;
    private final Predicate predicate;
    private final List<Action> actions;
    private final String description;
    private final Boolean startOnCreation;
    private final Map<String, String> tags;
    private final EventBatchingCondition eventBatchingCondition;

    private CreateTriggerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.workflowName = builder.workflowName;
        this.type = builder.type;
        this.schedule = builder.schedule;
        this.predicate = builder.predicate;
        this.actions = builder.actions;
        this.description = builder.description;
        this.startOnCreation = builder.startOnCreation;
        this.tags = builder.tags;
        this.eventBatchingCondition = builder.eventBatchingCondition;
    }

    public final String name() {
        return this.name;
    }

    public final String workflowName() {
        return this.workflowName;
    }

    public final TriggerType type() {
        return TriggerType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final Predicate predicate() {
        return this.predicate;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<Action> actions() {
        return this.actions;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean startOnCreation() {
        return this.startOnCreation;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final EventBatchingCondition eventBatchingCondition() {
        return this.eventBatchingCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.startOnCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBatchingCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTriggerRequest)) {
            return false;
        }
        CreateTriggerRequest other = (CreateTriggerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.workflowName(), other.workflowName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.predicate(), other.predicate()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.startOnCreation(), other.startOnCreation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.eventBatchingCondition(), other.eventBatchingCondition());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTriggerRequest").add("Name", (Object)this.name()).add("WorkflowName", (Object)this.workflowName()).add("Type", (Object)this.typeAsString()).add("Schedule", (Object)this.schedule()).add("Predicate", (Object)this.predicate()).add("Actions", this.hasActions() ? this.actions() : null).add("Description", (Object)this.description()).add("StartOnCreation", (Object)this.startOnCreation()).add("Tags", this.hasTags() ? this.tags() : null).add("EventBatchingCondition", (Object)this.eventBatchingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "WorkflowName": {
                return Optional.ofNullable(clazz.cast(this.workflowName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Predicate": {
                return Optional.ofNullable(clazz.cast(this.predicate()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StartOnCreation": {
                return Optional.ofNullable(clazz.cast(this.startOnCreation()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EventBatchingCondition": {
                return Optional.ofNullable(clazz.cast(this.eventBatchingCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTriggerRequest, T> g) {
        return obj -> g.apply((CreateTriggerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String workflowName;
        private String type;
        private String schedule;
        private Predicate predicate;
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Boolean startOnCreation;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private EventBatchingCondition eventBatchingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTriggerRequest model) {
            super(model);
            this.name(model.name);
            this.workflowName(model.workflowName);
            this.type(model.type);
            this.schedule(model.schedule);
            this.predicate(model.predicate);
            this.actions(model.actions);
            this.description(model.description);
            this.startOnCreation(model.startOnCreation);
            this.tags(model.tags);
            this.eventBatchingCondition(model.eventBatchingCondition);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getWorkflowName() {
            return this.workflowName;
        }

        public final void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @Override
        @Transient
        public final Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(TriggerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        @Transient
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        @Transient
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getStartOnCreation() {
            return this.startOnCreation;
        }

        public final void setStartOnCreation(Boolean startOnCreation) {
            this.startOnCreation = startOnCreation;
        }

        @Override
        @Transient
        public final Builder startOnCreation(Boolean startOnCreation) {
            this.startOnCreation = startOnCreation;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final EventBatchingCondition.Builder getEventBatchingCondition() {
            return this.eventBatchingCondition != null ? this.eventBatchingCondition.toBuilder() : null;
        }

        public final void setEventBatchingCondition(EventBatchingCondition.BuilderImpl eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition != null ? eventBatchingCondition.build() : null;
        }

        @Override
        @Transient
        public final Builder eventBatchingCondition(EventBatchingCondition eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTriggerRequest build() {
            return new CreateTriggerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTriggerRequest> {
        public Builder name(String var1);

        public Builder workflowName(String var1);

        public Builder type(String var1);

        public Builder type(TriggerType var1);

        public Builder schedule(String var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().applyMutation(predicate)).build());
        }

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder description(String var1);

        public Builder startOnCreation(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder eventBatchingCondition(EventBatchingCondition var1);

        default public Builder eventBatchingCondition(Consumer<EventBatchingCondition.Builder> eventBatchingCondition) {
            return this.eventBatchingCondition((EventBatchingCondition)((EventBatchingCondition.Builder)EventBatchingCondition.builder().applyMutation(eventBatchingCondition)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

