/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.BatchStopJobRunJobRunIdListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchStopJobRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchStopJobRunRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(BatchStopJobRunRequest.getter(BatchStopJobRunRequest::jobName)).setter(BatchStopJobRunRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<List<String>> JOB_RUN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobRunIds").getter(BatchStopJobRunRequest.getter(BatchStopJobRunRequest::jobRunIds)).setter(BatchStopJobRunRequest.setter(Builder::jobRunIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobRunIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_RUN_IDS_FIELD));
    private final String jobName;
    private final List<String> jobRunIds;

    private BatchStopJobRunRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobRunIds = builder.jobRunIds;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final boolean hasJobRunIds() {
        return this.jobRunIds != null && !(this.jobRunIds instanceof SdkAutoConstructList);
    }

    public final List<String> jobRunIds() {
        return this.jobRunIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobRunIds() ? this.jobRunIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStopJobRunRequest)) {
            return false;
        }
        BatchStopJobRunRequest other = (BatchStopJobRunRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && this.hasJobRunIds() == other.hasJobRunIds() && Objects.equals(this.jobRunIds(), other.jobRunIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchStopJobRunRequest").add("JobName", (Object)this.jobName()).add("JobRunIds", this.hasJobRunIds() ? this.jobRunIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobRunIds": {
                return Optional.ofNullable(clazz.cast(this.jobRunIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStopJobRunRequest, T> g) {
        return obj -> g.apply((BatchStopJobRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private List<String> jobRunIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStopJobRunRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobRunIds(model.jobRunIds);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        @Transient
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Collection<String> getJobRunIds() {
            if (this.jobRunIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobRunIds;
        }

        public final void setJobRunIds(Collection<String> jobRunIds) {
            this.jobRunIds = BatchStopJobRunJobRunIdListCopier.copy(jobRunIds);
        }

        @Override
        @Transient
        public final Builder jobRunIds(Collection<String> jobRunIds) {
            this.jobRunIds = BatchStopJobRunJobRunIdListCopier.copy(jobRunIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder jobRunIds(String ... jobRunIds) {
            this.jobRunIds(Arrays.asList(jobRunIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStopJobRunRequest build() {
            return new BatchStopJobRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchStopJobRunRequest> {
        public Builder jobName(String var1);

        public Builder jobRunIds(Collection<String> var1);

        public Builder jobRunIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

