/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetWorkflowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetWorkflowRequest.getter(GetWorkflowRequest::name)).setter(GetWorkflowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> INCLUDE_GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeGraph").getter(GetWorkflowRequest.getter(GetWorkflowRequest::includeGraph)).setter(GetWorkflowRequest.setter(Builder::includeGraph)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeGraph").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INCLUDE_GRAPH_FIELD));
    private final String name;
    private final Boolean includeGraph;

    private GetWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.includeGraph = builder.includeGraph;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean includeGraph() {
        return this.includeGraph;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeGraph());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRequest)) {
            return false;
        }
        GetWorkflowRequest other = (GetWorkflowRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.includeGraph(), other.includeGraph());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowRequest").add("Name", (Object)this.name()).add("IncludeGraph", (Object)this.includeGraph()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "IncludeGraph": {
                return Optional.ofNullable(clazz.cast(this.includeGraph()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRequest, T> g) {
        return obj -> g.apply((GetWorkflowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private Boolean includeGraph;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRequest model) {
            super(model);
            this.name(model.name);
            this.includeGraph(model.includeGraph);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getIncludeGraph() {
            return this.includeGraph;
        }

        @Override
        public final Builder includeGraph(Boolean includeGraph) {
            this.includeGraph = includeGraph;
            return this;
        }

        public final void setIncludeGraph(Boolean includeGraph) {
            this.includeGraph = includeGraph;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkflowRequest build() {
            return new GetWorkflowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRequest> {
        public Builder name(String var1);

        public Builder includeGraph(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

