/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.MLTransform;
import software.amazon.awssdk.services.glue.model.TransformListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMlTransformsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetMlTransformsResponse> {
    private static final SdkField<List<MLTransform>> TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Transforms").getter(GetMlTransformsResponse.getter(GetMlTransformsResponse::transforms)).setter(GetMlTransformsResponse.setter(Builder::transforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MLTransform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMlTransformsResponse.getter(GetMlTransformsResponse::nextToken)).setter(GetMlTransformsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MLTransform> transforms;
    private final String nextToken;

    private GetMlTransformsResponse(BuilderImpl builder) {
        super(builder);
        this.transforms = builder.transforms;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransforms() {
        return this.transforms != null && !(this.transforms instanceof SdkAutoConstructList);
    }

    public final List<MLTransform> transforms() {
        return this.transforms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransforms() ? this.transforms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlTransformsResponse)) {
            return false;
        }
        GetMlTransformsResponse other = (GetMlTransformsResponse)((Object)obj);
        return this.hasTransforms() == other.hasTransforms() && Objects.equals(this.transforms(), other.transforms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetMlTransformsResponse").add("Transforms", this.hasTransforms() ? this.transforms() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Transforms": {
                return Optional.ofNullable(clazz.cast(this.transforms()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlTransformsResponse, T> g) {
        return obj -> g.apply((GetMlTransformsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<MLTransform> transforms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlTransformsResponse model) {
            super(model);
            this.transforms(model.transforms);
            this.nextToken(model.nextToken);
        }

        public final Collection<MLTransform.Builder> getTransforms() {
            if (this.transforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.transforms != null ? (Collection)this.transforms.stream().map(MLTransform::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder transforms(Collection<MLTransform> transforms) {
            this.transforms = TransformListCopier.copy(transforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transforms(MLTransform ... transforms) {
            this.transforms(Arrays.asList(transforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transforms(Consumer<MLTransform.Builder> ... transforms) {
            this.transforms(Stream.of(transforms).map(c -> (MLTransform)((MLTransform.Builder)MLTransform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTransforms(Collection<MLTransform.BuilderImpl> transforms) {
            this.transforms = TransformListCopier.copyFromBuilder(transforms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetMlTransformsResponse build() {
            return new GetMlTransformsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMlTransformsResponse> {
        public Builder transforms(Collection<MLTransform> var1);

        public Builder transforms(MLTransform ... var1);

        public Builder transforms(Consumer<MLTransform.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

