/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GetColumnNamesListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetColumnStatisticsForPartitionRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetColumnStatisticsForPartitionRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(GetColumnStatisticsForPartitionRequest.getter(GetColumnStatisticsForPartitionRequest::catalogId)).setter(GetColumnStatisticsForPartitionRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GetColumnStatisticsForPartitionRequest.getter(GetColumnStatisticsForPartitionRequest::databaseName)).setter(GetColumnStatisticsForPartitionRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(GetColumnStatisticsForPartitionRequest.getter(GetColumnStatisticsForPartitionRequest::tableName)).setter(GetColumnStatisticsForPartitionRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<String>> PARTITION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionValues").getter(GetColumnStatisticsForPartitionRequest.getter(GetColumnStatisticsForPartitionRequest::partitionValues)).setter(GetColumnStatisticsForPartitionRequest.setter(Builder::partitionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnNames").getter(GetColumnStatisticsForPartitionRequest.getter(GetColumnStatisticsForPartitionRequest::columnNames)).setter(GetColumnStatisticsForPartitionRequest.setter(Builder::columnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, PARTITION_VALUES_FIELD, COLUMN_NAMES_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final List<String> partitionValues;
    private final List<String> columnNames;

    private GetColumnStatisticsForPartitionRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.partitionValues = builder.partitionValues;
        this.columnNames = builder.columnNames;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasPartitionValues() {
        return this.partitionValues != null && !(this.partitionValues instanceof SdkAutoConstructList);
    }

    public final List<String> partitionValues() {
        return this.partitionValues;
    }

    public final boolean hasColumnNames() {
        return this.columnNames != null && !(this.columnNames instanceof SdkAutoConstructList);
    }

    public final List<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionValues() ? this.partitionValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNames() ? this.columnNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsForPartitionRequest)) {
            return false;
        }
        GetColumnStatisticsForPartitionRequest other = (GetColumnStatisticsForPartitionRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasPartitionValues() == other.hasPartitionValues() && Objects.equals(this.partitionValues(), other.partitionValues()) && this.hasColumnNames() == other.hasColumnNames() && Objects.equals(this.columnNames(), other.columnNames());
    }

    public final String toString() {
        return ToString.builder((String)"GetColumnStatisticsForPartitionRequest").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("PartitionValues", this.hasPartitionValues() ? this.partitionValues() : null).add("ColumnNames", this.hasColumnNames() ? this.columnNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "PartitionValues": {
                return Optional.ofNullable(clazz.cast(this.partitionValues()));
            }
            case "ColumnNames": {
                return Optional.ofNullable(clazz.cast(this.columnNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsForPartitionRequest, T> g) {
        return obj -> g.apply((GetColumnStatisticsForPartitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsForPartitionRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.partitionValues(model.partitionValues);
            this.columnNames(model.columnNames);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<String> getPartitionValues() {
            if (this.partitionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionValues;
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String ... partitionValues) {
            this.partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
        }

        public final Collection<String> getColumnNames() {
            if (this.columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNames;
        }

        @Override
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = GetColumnNamesListCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(String ... columnNames) {
            this.columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = GetColumnNamesListCopier.copy(columnNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetColumnStatisticsForPartitionRequest build() {
            return new GetColumnStatisticsForPartitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetColumnStatisticsForPartitionRequest> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder partitionValues(Collection<String> var1);

        public Builder partitionValues(String ... var1);

        public Builder columnNames(Collection<String> var1);

        public Builder columnNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

