/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.CrawlerNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCrawlersRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchGetCrawlersRequest> {
    private static final SdkField<List<String>> CRAWLER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CrawlerNames").getter(BatchGetCrawlersRequest.getter(BatchGetCrawlersRequest::crawlerNames)).setter(BatchGetCrawlersRequest.setter(Builder::crawlerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAMES_FIELD));
    private final List<String> crawlerNames;

    private BatchGetCrawlersRequest(BuilderImpl builder) {
        super(builder);
        this.crawlerNames = builder.crawlerNames;
    }

    public final boolean hasCrawlerNames() {
        return this.crawlerNames != null && !(this.crawlerNames instanceof SdkAutoConstructList);
    }

    public final List<String> crawlerNames() {
        return this.crawlerNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCrawlerNames() ? this.crawlerNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCrawlersRequest)) {
            return false;
        }
        BatchGetCrawlersRequest other = (BatchGetCrawlersRequest)((Object)obj);
        return this.hasCrawlerNames() == other.hasCrawlerNames() && Objects.equals(this.crawlerNames(), other.crawlerNames());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCrawlersRequest").add("CrawlerNames", this.hasCrawlerNames() ? this.crawlerNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlerNames": {
                return Optional.ofNullable(clazz.cast(this.crawlerNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCrawlersRequest, T> g) {
        return obj -> g.apply((BatchGetCrawlersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<String> crawlerNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCrawlersRequest model) {
            super(model);
            this.crawlerNames(model.crawlerNames);
        }

        public final Collection<String> getCrawlerNames() {
            if (this.crawlerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.crawlerNames;
        }

        @Override
        public final Builder crawlerNames(Collection<String> crawlerNames) {
            this.crawlerNames = CrawlerNameListCopier.copy(crawlerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerNames(String ... crawlerNames) {
            this.crawlerNames(Arrays.asList(crawlerNames));
            return this;
        }

        public final void setCrawlerNames(Collection<String> crawlerNames) {
            this.crawlerNames = CrawlerNameListCopier.copy(crawlerNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCrawlersRequest build() {
            return new BatchGetCrawlersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCrawlersRequest> {
        public Builder crawlerNames(Collection<String> var1);

        public Builder crawlerNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

