/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.Compatibility;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.services.glue.model.SchemaVersionNumber;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSchemaRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, UpdateSchemaRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::schemaId)).setter(UpdateSchemaRequest.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<SchemaVersionNumber> SCHEMA_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaVersionNumber").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::schemaVersionNumber)).setter(UpdateSchemaRequest.setter(Builder::schemaVersionNumber)).constructor(SchemaVersionNumber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build()}).build();
    private static final SdkField<String> COMPATIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compatibility").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::compatibilityAsString)).setter(UpdateSchemaRequest.setter(Builder::compatibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compatibility").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateSchemaRequest.getter(UpdateSchemaRequest::description)).setter(UpdateSchemaRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, SCHEMA_VERSION_NUMBER_FIELD, COMPATIBILITY_FIELD, DESCRIPTION_FIELD));
    private final SchemaId schemaId;
    private final SchemaVersionNumber schemaVersionNumber;
    private final String compatibility;
    private final String description;

    private UpdateSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
        this.compatibility = builder.compatibility;
        this.description = builder.description;
    }

    public final SchemaId schemaId() {
        return this.schemaId;
    }

    public final SchemaVersionNumber schemaVersionNumber() {
        return this.schemaVersionNumber;
    }

    public final Compatibility compatibility() {
        return Compatibility.fromValue(this.compatibility);
    }

    public final String compatibilityAsString() {
        return this.compatibility;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaRequest)) {
            return false;
        }
        UpdateSchemaRequest other = (UpdateSchemaRequest)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.schemaVersionNumber(), other.schemaVersionNumber()) && Objects.equals(this.compatibilityAsString(), other.compatibilityAsString()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSchemaRequest").add("SchemaId", (Object)this.schemaId()).add("SchemaVersionNumber", (Object)this.schemaVersionNumber()).add("Compatibility", (Object)this.compatibilityAsString()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "SchemaVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionNumber()));
            }
            case "Compatibility": {
                return Optional.ofNullable(clazz.cast(this.compatibilityAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaRequest, T> g) {
        return obj -> g.apply((UpdateSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private SchemaVersionNumber schemaVersionNumber;
        private String compatibility;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaRequest model) {
            super(model);
            this.schemaId(model.schemaId);
            this.schemaVersionNumber(model.schemaVersionNumber);
            this.compatibility(model.compatibility);
            this.description(model.description);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        public final SchemaVersionNumber.Builder getSchemaVersionNumber() {
            return this.schemaVersionNumber != null ? this.schemaVersionNumber.toBuilder() : null;
        }

        @Override
        public final Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        public final void setSchemaVersionNumber(SchemaVersionNumber.BuilderImpl schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber != null ? schemaVersionNumber.build() : null;
        }

        public final String getCompatibility() {
            return this.compatibility;
        }

        @Override
        public final Builder compatibility(String compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        @Override
        public final Builder compatibility(Compatibility compatibility) {
            this.compatibility(compatibility == null ? null : compatibility.toString());
            return this;
        }

        public final void setCompatibility(String compatibility) {
            this.compatibility = compatibility;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSchemaRequest build() {
            return new UpdateSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSchemaRequest> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder schemaVersionNumber(SchemaVersionNumber var1);

        default public Builder schemaVersionNumber(Consumer<SchemaVersionNumber.Builder> schemaVersionNumber) {
            return this.schemaVersionNumber((SchemaVersionNumber)((SchemaVersionNumber.Builder)SchemaVersionNumber.builder().applyMutation(schemaVersionNumber)).build());
        }

        public Builder compatibility(String var1);

        public Builder compatibility(Compatibility var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

