/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CrawlerNodeDetails;
import software.amazon.awssdk.services.glue.model.JobNodeDetails;
import software.amazon.awssdk.services.glue.model.NodeType;
import software.amazon.awssdk.services.glue.model.TriggerNodeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Node.getter(Node::typeAsString)).setter(Node.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Node.getter(Node::name)).setter(Node.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> UNIQUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniqueId").getter(Node.getter(Node::uniqueId)).setter(Node.setter(Builder::uniqueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueId").build()}).build();
    private static final SdkField<TriggerNodeDetails> TRIGGER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TriggerDetails").getter(Node.getter(Node::triggerDetails)).setter(Node.setter(Builder::triggerDetails)).constructor(TriggerNodeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerDetails").build()}).build();
    private static final SdkField<JobNodeDetails> JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobDetails").getter(Node.getter(Node::jobDetails)).setter(Node.setter(Builder::jobDetails)).constructor(JobNodeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDetails").build()}).build();
    private static final SdkField<CrawlerNodeDetails> CRAWLER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CrawlerDetails").getter(Node.getter(Node::crawlerDetails)).setter(Node.setter(Builder::crawlerDetails)).constructor(CrawlerNodeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, UNIQUE_ID_FIELD, TRIGGER_DETAILS_FIELD, JOB_DETAILS_FIELD, CRAWLER_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String uniqueId;
    private final TriggerNodeDetails triggerDetails;
    private final JobNodeDetails jobDetails;
    private final CrawlerNodeDetails crawlerDetails;

    private Node(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.uniqueId = builder.uniqueId;
        this.triggerDetails = builder.triggerDetails;
        this.jobDetails = builder.jobDetails;
        this.crawlerDetails = builder.crawlerDetails;
    }

    public final NodeType type() {
        return NodeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String uniqueId() {
        return this.uniqueId;
    }

    public final TriggerNodeDetails triggerDetails() {
        return this.triggerDetails;
    }

    public final JobNodeDetails jobDetails() {
        return this.jobDetails;
    }

    public final CrawlerNodeDetails crawlerDetails() {
        return this.crawlerDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.uniqueId(), other.uniqueId()) && Objects.equals(this.triggerDetails(), other.triggerDetails()) && Objects.equals(this.jobDetails(), other.jobDetails()) && Objects.equals(this.crawlerDetails(), other.crawlerDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Node").add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("UniqueId", (Object)this.uniqueId()).add("TriggerDetails", (Object)this.triggerDetails()).add("JobDetails", (Object)this.jobDetails()).add("CrawlerDetails", (Object)this.crawlerDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "UniqueId": {
                return Optional.ofNullable(clazz.cast(this.uniqueId()));
            }
            case "TriggerDetails": {
                return Optional.ofNullable(clazz.cast(this.triggerDetails()));
            }
            case "JobDetails": {
                return Optional.ofNullable(clazz.cast(this.jobDetails()));
            }
            case "CrawlerDetails": {
                return Optional.ofNullable(clazz.cast(this.crawlerDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String uniqueId;
        private TriggerNodeDetails triggerDetails;
        private JobNodeDetails jobDetails;
        private CrawlerNodeDetails crawlerDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.type(model.type);
            this.name(model.name);
            this.uniqueId(model.uniqueId);
            this.triggerDetails(model.triggerDetails);
            this.jobDetails(model.jobDetails);
            this.crawlerDetails(model.crawlerDetails);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NodeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getUniqueId() {
            return this.uniqueId;
        }

        @Override
        public final Builder uniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }

        public final void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public final TriggerNodeDetails.Builder getTriggerDetails() {
            return this.triggerDetails != null ? this.triggerDetails.toBuilder() : null;
        }

        @Override
        public final Builder triggerDetails(TriggerNodeDetails triggerDetails) {
            this.triggerDetails = triggerDetails;
            return this;
        }

        public final void setTriggerDetails(TriggerNodeDetails.BuilderImpl triggerDetails) {
            this.triggerDetails = triggerDetails != null ? triggerDetails.build() : null;
        }

        public final JobNodeDetails.Builder getJobDetails() {
            return this.jobDetails != null ? this.jobDetails.toBuilder() : null;
        }

        @Override
        public final Builder jobDetails(JobNodeDetails jobDetails) {
            this.jobDetails = jobDetails;
            return this;
        }

        public final void setJobDetails(JobNodeDetails.BuilderImpl jobDetails) {
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
        }

        public final CrawlerNodeDetails.Builder getCrawlerDetails() {
            return this.crawlerDetails != null ? this.crawlerDetails.toBuilder() : null;
        }

        @Override
        public final Builder crawlerDetails(CrawlerNodeDetails crawlerDetails) {
            this.crawlerDetails = crawlerDetails;
            return this;
        }

        public final void setCrawlerDetails(CrawlerNodeDetails.BuilderImpl crawlerDetails) {
            this.crawlerDetails = crawlerDetails != null ? crawlerDetails.build() : null;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder type(String var1);

        public Builder type(NodeType var1);

        public Builder name(String var1);

        public Builder uniqueId(String var1);

        public Builder triggerDetails(TriggerNodeDetails var1);

        default public Builder triggerDetails(Consumer<TriggerNodeDetails.Builder> triggerDetails) {
            return this.triggerDetails((TriggerNodeDetails)((TriggerNodeDetails.Builder)TriggerNodeDetails.builder().applyMutation(triggerDetails)).build());
        }

        public Builder jobDetails(JobNodeDetails var1);

        default public Builder jobDetails(Consumer<JobNodeDetails.Builder> jobDetails) {
            return this.jobDetails((JobNodeDetails)((JobNodeDetails.Builder)JobNodeDetails.builder().applyMutation(jobDetails)).build());
        }

        public Builder crawlerDetails(CrawlerNodeDetails var1);

        default public Builder crawlerDetails(Consumer<CrawlerNodeDetails.Builder> crawlerDetails) {
            return this.crawlerDetails((CrawlerNodeDetails)((CrawlerNodeDetails.Builder)CrawlerNodeDetails.builder().applyMutation(crawlerDetails)).build());
        }
    }
}

