/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.AdditionalPlanOptionsMapCopier;
import software.amazon.awssdk.services.glue.model.CatalogEntriesCopier;
import software.amazon.awssdk.services.glue.model.CatalogEntry;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.Language;
import software.amazon.awssdk.services.glue.model.Location;
import software.amazon.awssdk.services.glue.model.MappingEntry;
import software.amazon.awssdk.services.glue.model.MappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPlanRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, GetPlanRequest> {
    private static final SdkField<List<MappingEntry>> MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Mapping").getter(GetPlanRequest.getter(GetPlanRequest::mapping)).setter(GetPlanRequest.setter(Builder::mapping)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MappingEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CatalogEntry> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(GetPlanRequest.getter(GetPlanRequest::source)).setter(GetPlanRequest.setter(Builder::source)).constructor(CatalogEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<CatalogEntry>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sinks").getter(GetPlanRequest.getter(GetPlanRequest::sinks)).setter(GetPlanRequest.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CatalogEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(GetPlanRequest.getter(GetPlanRequest::location)).setter(GetPlanRequest.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(GetPlanRequest.getter(GetPlanRequest::languageAsString)).setter(GetPlanRequest.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_PLAN_OPTIONS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalPlanOptionsMap").getter(GetPlanRequest.getter(GetPlanRequest::additionalPlanOptionsMap)).setter(GetPlanRequest.setter(Builder::additionalPlanOptionsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalPlanOptionsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_FIELD, SOURCE_FIELD, SINKS_FIELD, LOCATION_FIELD, LANGUAGE_FIELD, ADDITIONAL_PLAN_OPTIONS_MAP_FIELD));
    private final List<MappingEntry> mapping;
    private final CatalogEntry source;
    private final List<CatalogEntry> sinks;
    private final Location location;
    private final String language;
    private final Map<String, String> additionalPlanOptionsMap;

    private GetPlanRequest(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
        this.source = builder.source;
        this.sinks = builder.sinks;
        this.location = builder.location;
        this.language = builder.language;
        this.additionalPlanOptionsMap = builder.additionalPlanOptionsMap;
    }

    public final boolean hasMapping() {
        return this.mapping != null && !(this.mapping instanceof SdkAutoConstructList);
    }

    public final List<MappingEntry> mapping() {
        return this.mapping;
    }

    public final CatalogEntry source() {
        return this.source;
    }

    public final boolean hasSinks() {
        return this.sinks != null && !(this.sinks instanceof SdkAutoConstructList);
    }

    public final List<CatalogEntry> sinks() {
        return this.sinks;
    }

    public final Location location() {
        return this.location;
    }

    public final Language language() {
        return Language.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final boolean hasAdditionalPlanOptionsMap() {
        return this.additionalPlanOptionsMap != null && !(this.additionalPlanOptionsMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalPlanOptionsMap() {
        return this.additionalPlanOptionsMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapping() ? this.mapping() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSinks() ? this.sinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalPlanOptionsMap() ? this.additionalPlanOptionsMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanRequest)) {
            return false;
        }
        GetPlanRequest other = (GetPlanRequest)((Object)obj);
        return this.hasMapping() == other.hasMapping() && Objects.equals(this.mapping(), other.mapping()) && Objects.equals(this.source(), other.source()) && this.hasSinks() == other.hasSinks() && Objects.equals(this.sinks(), other.sinks()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.languageAsString(), other.languageAsString()) && this.hasAdditionalPlanOptionsMap() == other.hasAdditionalPlanOptionsMap() && Objects.equals(this.additionalPlanOptionsMap(), other.additionalPlanOptionsMap());
    }

    public final String toString() {
        return ToString.builder((String)"GetPlanRequest").add("Mapping", this.hasMapping() ? this.mapping() : null).add("Source", (Object)this.source()).add("Sinks", this.hasSinks() ? this.sinks() : null).add("Location", (Object)this.location()).add("Language", (Object)this.languageAsString()).add("AdditionalPlanOptionsMap", this.hasAdditionalPlanOptionsMap() ? this.additionalPlanOptionsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mapping": {
                return Optional.ofNullable(clazz.cast(this.mapping()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "AdditionalPlanOptionsMap": {
                return Optional.ofNullable(clazz.cast(this.additionalPlanOptionsMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPlanRequest, T> g) {
        return obj -> g.apply((GetPlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<MappingEntry> mapping = DefaultSdkAutoConstructList.getInstance();
        private CatalogEntry source;
        private List<CatalogEntry> sinks = DefaultSdkAutoConstructList.getInstance();
        private Location location;
        private String language;
        private Map<String, String> additionalPlanOptionsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanRequest model) {
            super(model);
            this.mapping(model.mapping);
            this.source(model.source);
            this.sinks(model.sinks);
            this.location(model.location);
            this.language(model.language);
            this.additionalPlanOptionsMap(model.additionalPlanOptionsMap);
        }

        public final Collection<MappingEntry.Builder> getMapping() {
            if (this.mapping instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mapping != null ? (Collection)this.mapping.stream().map(MappingEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry ... mapping) {
            this.mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder> ... mapping) {
            this.mapping(Stream.of(mapping).map(c -> (MappingEntry)((MappingEntry.Builder)MappingEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        public final CatalogEntry.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(CatalogEntry source) {
            this.source = source;
            return this;
        }

        public final void setSource(CatalogEntry.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<CatalogEntry.Builder> getSinks() {
            if (this.sinks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sinks != null ? (Collection)this.sinks.stream().map(CatalogEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sinks(Collection<CatalogEntry> sinks) {
            this.sinks = CatalogEntriesCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(CatalogEntry ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<CatalogEntry.Builder> ... sinks) {
            this.sinks(Stream.of(sinks).map(c -> (CatalogEntry)((CatalogEntry.Builder)CatalogEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSinks(Collection<CatalogEntry.BuilderImpl> sinks) {
            this.sinks = CatalogEntriesCopier.copyFromBuilder(sinks);
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getLanguage() {
            return this.language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final Map<String, String> getAdditionalPlanOptionsMap() {
            if (this.additionalPlanOptionsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalPlanOptionsMap;
        }

        @Override
        public final Builder additionalPlanOptionsMap(Map<String, String> additionalPlanOptionsMap) {
            this.additionalPlanOptionsMap = AdditionalPlanOptionsMapCopier.copy(additionalPlanOptionsMap);
            return this;
        }

        public final void setAdditionalPlanOptionsMap(Map<String, String> additionalPlanOptionsMap) {
            this.additionalPlanOptionsMap = AdditionalPlanOptionsMapCopier.copy(additionalPlanOptionsMap);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlanRequest build() {
            return new GetPlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPlanRequest> {
        public Builder mapping(Collection<MappingEntry> var1);

        public Builder mapping(MappingEntry ... var1);

        public Builder mapping(Consumer<MappingEntry.Builder> ... var1);

        public Builder source(CatalogEntry var1);

        default public Builder source(Consumer<CatalogEntry.Builder> source) {
            return this.source((CatalogEntry)((CatalogEntry.Builder)CatalogEntry.builder().applyMutation(source)).build());
        }

        public Builder sinks(Collection<CatalogEntry> var1);

        public Builder sinks(CatalogEntry ... var1);

        public Builder sinks(Consumer<CatalogEntry.Builder> ... var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder language(String var1);

        public Builder language(Language var1);

        public Builder additionalPlanOptionsMap(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

