/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.SchemaVersionErrorItem;
import software.amazon.awssdk.services.glue.model.SchemaVersionErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSchemaVersionsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, DeleteSchemaVersionsResponse> {
    private static final SdkField<List<SchemaVersionErrorItem>> SCHEMA_VERSION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaVersionErrors").getter(DeleteSchemaVersionsResponse.getter(DeleteSchemaVersionsResponse::schemaVersionErrors)).setter(DeleteSchemaVersionsResponse.setter(Builder::schemaVersionErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaVersionErrorItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_VERSION_ERRORS_FIELD));
    private final List<SchemaVersionErrorItem> schemaVersionErrors;

    private DeleteSchemaVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaVersionErrors = builder.schemaVersionErrors;
    }

    public final boolean hasSchemaVersionErrors() {
        return this.schemaVersionErrors != null && !(this.schemaVersionErrors instanceof SdkAutoConstructList);
    }

    public final List<SchemaVersionErrorItem> schemaVersionErrors() {
        return this.schemaVersionErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaVersionErrors() ? this.schemaVersionErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSchemaVersionsResponse)) {
            return false;
        }
        DeleteSchemaVersionsResponse other = (DeleteSchemaVersionsResponse)((Object)obj);
        return this.hasSchemaVersionErrors() == other.hasSchemaVersionErrors() && Objects.equals(this.schemaVersionErrors(), other.schemaVersionErrors());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSchemaVersionsResponse").add("SchemaVersionErrors", this.hasSchemaVersionErrors() ? this.schemaVersionErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaVersionErrors": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSchemaVersionsResponse, T> g) {
        return obj -> g.apply((DeleteSchemaVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<SchemaVersionErrorItem> schemaVersionErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSchemaVersionsResponse model) {
            super(model);
            this.schemaVersionErrors(model.schemaVersionErrors);
        }

        public final Collection<SchemaVersionErrorItem.Builder> getSchemaVersionErrors() {
            if (this.schemaVersionErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.schemaVersionErrors != null ? (Collection)this.schemaVersionErrors.stream().map(SchemaVersionErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaVersionErrors(Collection<SchemaVersionErrorItem> schemaVersionErrors) {
            this.schemaVersionErrors = SchemaVersionErrorListCopier.copy(schemaVersionErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersionErrors(SchemaVersionErrorItem ... schemaVersionErrors) {
            this.schemaVersionErrors(Arrays.asList(schemaVersionErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaVersionErrors(Consumer<SchemaVersionErrorItem.Builder> ... schemaVersionErrors) {
            this.schemaVersionErrors(Stream.of(schemaVersionErrors).map(c -> (SchemaVersionErrorItem)((SchemaVersionErrorItem.Builder)SchemaVersionErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSchemaVersionErrors(Collection<SchemaVersionErrorItem.BuilderImpl> schemaVersionErrors) {
            this.schemaVersionErrors = SchemaVersionErrorListCopier.copyFromBuilder(schemaVersionErrors);
        }

        @Override
        public DeleteSchemaVersionsResponse build() {
            return new DeleteSchemaVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSchemaVersionsResponse> {
        public Builder schemaVersionErrors(Collection<SchemaVersionErrorItem> var1);

        public Builder schemaVersionErrors(SchemaVersionErrorItem ... var1);

        public Builder schemaVersionErrors(Consumer<SchemaVersionErrorItem.Builder> ... var1);
    }
}

