/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobBookmarkEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobBookmarkEntry> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobBookmarkEntry.getter(JobBookmarkEntry::jobName)).setter(JobBookmarkEntry.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<Integer> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobBookmarkEntry.getter(JobBookmarkEntry::version)).setter(JobBookmarkEntry.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Integer> RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobBookmarkEntry.getter(JobBookmarkEntry::run)).setter(JobBookmarkEntry.setter(Builder::run)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Run").build()}).build();
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobBookmarkEntry.getter(JobBookmarkEntry::attempt)).setter(JobBookmarkEntry.setter(Builder::attempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attempt").build()}).build();
    private static final SdkField<String> PREVIOUS_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobBookmarkEntry.getter(JobBookmarkEntry::previousRunId)).setter(JobBookmarkEntry.setter(Builder::previousRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousRunId").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobBookmarkEntry.getter(JobBookmarkEntry::runId)).setter(JobBookmarkEntry.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> JOB_BOOKMARK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobBookmarkEntry.getter(JobBookmarkEntry::jobBookmark)).setter(JobBookmarkEntry.setter(Builder::jobBookmark)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobBookmark").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, VERSION_FIELD, RUN_FIELD, ATTEMPT_FIELD, PREVIOUS_RUN_ID_FIELD, RUN_ID_FIELD, JOB_BOOKMARK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final Integer version;
    private final Integer run;
    private final Integer attempt;
    private final String previousRunId;
    private final String runId;
    private final String jobBookmark;

    private JobBookmarkEntry(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.version = builder.version;
        this.run = builder.run;
        this.attempt = builder.attempt;
        this.previousRunId = builder.previousRunId;
        this.runId = builder.runId;
        this.jobBookmark = builder.jobBookmark;
    }

    public String jobName() {
        return this.jobName;
    }

    public Integer version() {
        return this.version;
    }

    public Integer run() {
        return this.run;
    }

    public Integer attempt() {
        return this.attempt;
    }

    public String previousRunId() {
        return this.previousRunId;
    }

    public String runId() {
        return this.runId;
    }

    public String jobBookmark() {
        return this.jobBookmark;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.run());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobBookmark());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobBookmarkEntry)) {
            return false;
        }
        JobBookmarkEntry other = (JobBookmarkEntry)obj;
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.run(), other.run()) && Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.previousRunId(), other.previousRunId()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.jobBookmark(), other.jobBookmark());
    }

    public String toString() {
        return ToString.builder((String)"JobBookmarkEntry").add("JobName", (Object)this.jobName()).add("Version", (Object)this.version()).add("Run", (Object)this.run()).add("Attempt", (Object)this.attempt()).add("PreviousRunId", (Object)this.previousRunId()).add("RunId", (Object)this.runId()).add("JobBookmark", (Object)this.jobBookmark()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Run": {
                return Optional.ofNullable(clazz.cast(this.run()));
            }
            case "Attempt": {
                return Optional.ofNullable(clazz.cast(this.attempt()));
            }
            case "PreviousRunId": {
                return Optional.ofNullable(clazz.cast(this.previousRunId()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "JobBookmark": {
                return Optional.ofNullable(clazz.cast(this.jobBookmark()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobBookmarkEntry, T> g) {
        return obj -> g.apply((JobBookmarkEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private Integer version;
        private Integer run;
        private Integer attempt;
        private String previousRunId;
        private String runId;
        private String jobBookmark;

        private BuilderImpl() {
        }

        private BuilderImpl(JobBookmarkEntry model) {
            this.jobName(model.jobName);
            this.version(model.version);
            this.run(model.run);
            this.attempt(model.attempt);
            this.previousRunId(model.previousRunId);
            this.runId(model.runId);
            this.jobBookmark(model.jobBookmark);
        }

        public final String getJobName() {
            return this.jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public final Integer getRun() {
            return this.run;
        }

        @Override
        public final Builder run(Integer run) {
            this.run = run;
            return this;
        }

        public final void setRun(Integer run) {
            this.run = run;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        public final String getPreviousRunId() {
            return this.previousRunId;
        }

        @Override
        public final Builder previousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
            return this;
        }

        public final void setPreviousRunId(String previousRunId) {
            this.previousRunId = previousRunId;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final String getJobBookmark() {
            return this.jobBookmark;
        }

        @Override
        public final Builder jobBookmark(String jobBookmark) {
            this.jobBookmark = jobBookmark;
            return this;
        }

        public final void setJobBookmark(String jobBookmark) {
            this.jobBookmark = jobBookmark;
        }

        public JobBookmarkEntry build() {
            return new JobBookmarkEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobBookmarkEntry> {
        public Builder jobName(String var1);

        public Builder version(Integer var1);

        public Builder run(Integer var1);

        public Builder attempt(Integer var1);

        public Builder previousRunId(String var1);

        public Builder runId(String var1);

        public Builder jobBookmark(String var1);
    }
}

