/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.SecurityConfiguration;
import software.amazon.awssdk.services.glue.model.SecurityConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSecurityConfigurationsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetSecurityConfigurationsResponse> {
    private static final SdkField<List<SecurityConfiguration>> SECURITY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetSecurityConfigurationsResponse.getter(GetSecurityConfigurationsResponse::securityConfigurations)).setter(GetSecurityConfigurationsResponse.setter(Builder::securityConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSecurityConfigurationsResponse.getter(GetSecurityConfigurationsResponse::nextToken)).setter(GetSecurityConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SecurityConfiguration> securityConfigurations;
    private final String nextToken;

    private GetSecurityConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.securityConfigurations = builder.securityConfigurations;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSecurityConfigurations() {
        return this.securityConfigurations != null && !(this.securityConfigurations instanceof SdkAutoConstructList);
    }

    public List<SecurityConfiguration> securityConfigurations() {
        return this.securityConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSecurityConfigurationsResponse)) {
            return false;
        }
        GetSecurityConfigurationsResponse other = (GetSecurityConfigurationsResponse)((Object)obj);
        return Objects.equals(this.securityConfigurations(), other.securityConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetSecurityConfigurationsResponse").add("SecurityConfigurations", this.securityConfigurations()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityConfigurations": {
                return Optional.ofNullable(clazz.cast(this.securityConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSecurityConfigurationsResponse, T> g) {
        return obj -> g.apply((GetSecurityConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<SecurityConfiguration> securityConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSecurityConfigurationsResponse model) {
            super(model);
            this.securityConfigurations(model.securityConfigurations);
            this.nextToken(model.nextToken);
        }

        public final Collection<SecurityConfiguration.Builder> getSecurityConfigurations() {
            return this.securityConfigurations != null ? (Collection)this.securityConfigurations.stream().map(SecurityConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder securityConfigurations(Collection<SecurityConfiguration> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copy(securityConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(SecurityConfiguration ... securityConfigurations) {
            this.securityConfigurations(Arrays.asList(securityConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigurations(Consumer<SecurityConfiguration.Builder> ... securityConfigurations) {
            this.securityConfigurations(Stream.of(securityConfigurations).map(c -> (SecurityConfiguration)((SecurityConfiguration.Builder)SecurityConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecurityConfigurations(Collection<SecurityConfiguration.BuilderImpl> securityConfigurations) {
            this.securityConfigurations = SecurityConfigurationListCopier.copyFromBuilder(securityConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSecurityConfigurationsResponse build() {
            return new GetSecurityConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSecurityConfigurationsResponse> {
        public Builder securityConfigurations(Collection<SecurityConfiguration> var1);

        public Builder securityConfigurations(SecurityConfiguration ... var1);

        public Builder securityConfigurations(Consumer<SecurityConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

