/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ErrorByNameCopier;
import software.amazon.awssdk.services.glue.model.ErrorDetail;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteConnectionResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, BatchDeleteConnectionResponse> {
    private static final SdkField<List<String>> SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteConnectionResponse.getter(BatchDeleteConnectionResponse::succeeded)).setter(BatchDeleteConnectionResponse.setter(Builder::succeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ErrorDetail>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(BatchDeleteConnectionResponse.getter(BatchDeleteConnectionResponse::errors)).setter(BatchDeleteConnectionResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCEEDED_FIELD, ERRORS_FIELD));
    private final List<String> succeeded;
    private final Map<String, ErrorDetail> errors;

    private BatchDeleteConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.succeeded = builder.succeeded;
        this.errors = builder.errors;
    }

    public boolean hasSucceeded() {
        return this.succeeded != null && !(this.succeeded instanceof SdkAutoConstructList);
    }

    public List<String> succeeded() {
        return this.succeeded;
    }

    public boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructMap);
    }

    public Map<String, ErrorDetail> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.errors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteConnectionResponse)) {
            return false;
        }
        BatchDeleteConnectionResponse other = (BatchDeleteConnectionResponse)((Object)obj);
        return Objects.equals(this.succeeded(), other.succeeded()) && Objects.equals(this.errors(), other.errors());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteConnectionResponse").add("Succeeded", this.succeeded()).add("Errors", this.errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Succeeded": {
                return Optional.ofNullable(clazz.cast(this.succeeded()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteConnectionResponse, T> g) {
        return obj -> g.apply((BatchDeleteConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<String> succeeded = DefaultSdkAutoConstructList.getInstance();
        private Map<String, ErrorDetail> errors = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteConnectionResponse model) {
            super(model);
            this.succeeded(model.succeeded);
            this.errors(model.errors);
        }

        public final Collection<String> getSucceeded() {
            return this.succeeded;
        }

        @Override
        public final Builder succeeded(Collection<String> succeeded) {
            this.succeeded = NameStringListCopier.copy(succeeded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeeded(String ... succeeded) {
            this.succeeded(Arrays.asList(succeeded));
            return this;
        }

        public final void setSucceeded(Collection<String> succeeded) {
            this.succeeded = NameStringListCopier.copy(succeeded);
        }

        public final Map<String, ErrorDetail.Builder> getErrors() {
            return this.errors != null ? CollectionUtils.mapValues(this.errors, ErrorDetail::toBuilder) : null;
        }

        @Override
        public final Builder errors(Map<String, ErrorDetail> errors) {
            this.errors = ErrorByNameCopier.copy(errors);
            return this;
        }

        public final void setErrors(Map<String, ErrorDetail.BuilderImpl> errors) {
            this.errors = ErrorByNameCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchDeleteConnectionResponse build() {
            return new BatchDeleteConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteConnectionResponse> {
        public Builder succeeded(Collection<String> var1);

        public Builder succeeded(String ... var1);

        public Builder errors(Map<String, ErrorDetail> var1);
    }
}

