/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.CrossAccountResource;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountResourcesResponse;

public class ListCrossAccountResourcesPublisher
implements SdkPublisher<ListCrossAccountResourcesResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCrossAccountResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCrossAccountResourcesPublisher(GlobalAcceleratorAsyncClient client, ListCrossAccountResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCrossAccountResourcesPublisher(GlobalAcceleratorAsyncClient client, ListCrossAccountResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCrossAccountResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCrossAccountResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CrossAccountResource> crossAccountResources() {
        return this.flatMapIterable(response -> response.crossAccountResources());
    }

    private class ListCrossAccountResourcesResponseFetcher
    implements AsyncPageFetcher<ListCrossAccountResourcesResponse> {
        private ListCrossAccountResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListCrossAccountResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCrossAccountResourcesResponse> nextPage(ListCrossAccountResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListCrossAccountResourcesPublisher.this.client.listCrossAccountResources(ListCrossAccountResourcesPublisher.this.firstRequest);
            }
            return ListCrossAccountResourcesPublisher.this.client.listCrossAccountResources((ListCrossAccountResourcesRequest)((Object)ListCrossAccountResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

