/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.Listener;

public class ListListenersPublisher
implements SdkPublisher<ListListenersResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListListenersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListListenersPublisher(GlobalAcceleratorAsyncClient client, ListListenersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListListenersPublisher(GlobalAcceleratorAsyncClient client, ListListenersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListListenersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListListenersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Listener> listeners() {
        return this.flatMapIterable(response -> response.listeners());
    }

    private class ListListenersResponseFetcher
    implements AsyncPageFetcher<ListListenersResponse> {
        private ListListenersResponseFetcher() {
        }

        public boolean hasNextPage(ListListenersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListListenersResponse> nextPage(ListListenersResponse previousPage) {
            if (previousPage == null) {
                return ListListenersPublisher.this.client.listListeners(ListListenersPublisher.this.firstRequest);
            }
            return ListListenersPublisher.this.client.listListeners((ListListenersRequest)((Object)ListListenersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

