/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointGroup;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;

public class ListCustomRoutingEndpointGroupsPublisher
implements SdkPublisher<ListCustomRoutingEndpointGroupsResponse> {
    private final GlobalAcceleratorAsyncClient client;
    private final ListCustomRoutingEndpointGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomRoutingEndpointGroupsPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingEndpointGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomRoutingEndpointGroupsPublisher(GlobalAcceleratorAsyncClient client, ListCustomRoutingEndpointGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomRoutingEndpointGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomRoutingEndpointGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomRoutingEndpointGroup> endpointGroups() {
        return this.flatMapIterable(response -> response.endpointGroups());
    }

    private class ListCustomRoutingEndpointGroupsResponseFetcher
    implements AsyncPageFetcher<ListCustomRoutingEndpointGroupsResponse> {
        private ListCustomRoutingEndpointGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomRoutingEndpointGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomRoutingEndpointGroupsResponse> nextPage(ListCustomRoutingEndpointGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomRoutingEndpointGroupsPublisher.this.client.listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsPublisher.this.firstRequest);
            }
            return ListCustomRoutingEndpointGroupsPublisher.this.client.listCustomRoutingEndpointGroups((ListCustomRoutingEndpointGroupsRequest)((Object)ListCustomRoutingEndpointGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

