/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.internal.UserAgentUtils;
import software.amazon.awssdk.services.globalaccelerator.model.Attachment;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse;

public class ListCrossAccountAttachmentsIterable
implements SdkIterable<ListCrossAccountAttachmentsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListCrossAccountAttachmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCrossAccountAttachmentsIterable(GlobalAcceleratorClient client, ListCrossAccountAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCrossAccountAttachmentsResponseFetcher();
    }

    public Iterator<ListCrossAccountAttachmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Attachment> crossAccountAttachments() {
        Function<ListCrossAccountAttachmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.crossAccountAttachments() != null) {
                return response.crossAccountAttachments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCrossAccountAttachmentsResponseFetcher
    implements SyncPageFetcher<ListCrossAccountAttachmentsResponse> {
        private ListCrossAccountAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListCrossAccountAttachmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCrossAccountAttachmentsResponse nextPage(ListCrossAccountAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListCrossAccountAttachmentsIterable.this.client.listCrossAccountAttachments(ListCrossAccountAttachmentsIterable.this.firstRequest);
            }
            return ListCrossAccountAttachmentsIterable.this.client.listCrossAccountAttachments((ListCrossAccountAttachmentsRequest)((Object)ListCrossAccountAttachmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

