/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescriptionsCopier;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription;
import software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomRoutingEndpointGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomRoutingEndpointGroup> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupArn").getter(CustomRoutingEndpointGroup.getter(CustomRoutingEndpointGroup::endpointGroupArn)).setter(CustomRoutingEndpointGroup.setter(Builder::endpointGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()}).build();
    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointGroupRegion").getter(CustomRoutingEndpointGroup.getter(CustomRoutingEndpointGroup::endpointGroupRegion)).setter(CustomRoutingEndpointGroup.setter(Builder::endpointGroupRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build()}).build();
    private static final SdkField<List<CustomRoutingDestinationDescription>> DESTINATION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DestinationDescriptions").getter(CustomRoutingEndpointGroup.getter(CustomRoutingEndpointGroup::destinationDescriptions)).setter(CustomRoutingEndpointGroup.setter(Builder::destinationDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingDestinationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CustomRoutingEndpointDescription>> ENDPOINT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EndpointDescriptions").getter(CustomRoutingEndpointGroup.getter(CustomRoutingEndpointGroup::endpointDescriptions)).setter(CustomRoutingEndpointGroup.setter(Builder::endpointDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomRoutingEndpointDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD, ENDPOINT_GROUP_REGION_FIELD, DESTINATION_DESCRIPTIONS_FIELD, ENDPOINT_DESCRIPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointGroupArn", ENDPOINT_GROUP_ARN_FIELD);
            this.put("EndpointGroupRegion", ENDPOINT_GROUP_REGION_FIELD);
            this.put("DestinationDescriptions", DESTINATION_DESCRIPTIONS_FIELD);
            this.put("EndpointDescriptions", ENDPOINT_DESCRIPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String endpointGroupArn;
    private final String endpointGroupRegion;
    private final List<CustomRoutingDestinationDescription> destinationDescriptions;
    private final List<CustomRoutingEndpointDescription> endpointDescriptions;

    private CustomRoutingEndpointGroup(BuilderImpl builder) {
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.destinationDescriptions = builder.destinationDescriptions;
        this.endpointDescriptions = builder.endpointDescriptions;
    }

    public final String endpointGroupArn() {
        return this.endpointGroupArn;
    }

    public final String endpointGroupRegion() {
        return this.endpointGroupRegion;
    }

    public final boolean hasDestinationDescriptions() {
        return this.destinationDescriptions != null && !(this.destinationDescriptions instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingDestinationDescription> destinationDescriptions() {
        return this.destinationDescriptions;
    }

    public final boolean hasEndpointDescriptions() {
        return this.endpointDescriptions != null && !(this.endpointDescriptions instanceof SdkAutoConstructList);
    }

    public final List<CustomRoutingEndpointDescription> endpointDescriptions() {
        return this.endpointDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinationDescriptions() ? this.destinationDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpointDescriptions() ? this.endpointDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingEndpointGroup)) {
            return false;
        }
        CustomRoutingEndpointGroup other = (CustomRoutingEndpointGroup)obj;
        return Objects.equals(this.endpointGroupArn(), other.endpointGroupArn()) && Objects.equals(this.endpointGroupRegion(), other.endpointGroupRegion()) && this.hasDestinationDescriptions() == other.hasDestinationDescriptions() && Objects.equals(this.destinationDescriptions(), other.destinationDescriptions()) && this.hasEndpointDescriptions() == other.hasEndpointDescriptions() && Objects.equals(this.endpointDescriptions(), other.endpointDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"CustomRoutingEndpointGroup").add("EndpointGroupArn", (Object)this.endpointGroupArn()).add("EndpointGroupRegion", (Object)this.endpointGroupRegion()).add("DestinationDescriptions", this.hasDestinationDescriptions() ? this.destinationDescriptions() : null).add("EndpointDescriptions", this.hasEndpointDescriptions() ? this.endpointDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointGroupArn": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupArn()));
            }
            case "EndpointGroupRegion": {
                return Optional.ofNullable(clazz.cast(this.endpointGroupRegion()));
            }
            case "DestinationDescriptions": {
                return Optional.ofNullable(clazz.cast(this.destinationDescriptions()));
            }
            case "EndpointDescriptions": {
                return Optional.ofNullable(clazz.cast(this.endpointDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomRoutingEndpointGroup, T> g) {
        return obj -> g.apply((CustomRoutingEndpointGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointGroupArn;
        private String endpointGroupRegion;
        private List<CustomRoutingDestinationDescription> destinationDescriptions = DefaultSdkAutoConstructList.getInstance();
        private List<CustomRoutingEndpointDescription> endpointDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRoutingEndpointGroup model) {
            this.endpointGroupArn(model.endpointGroupArn);
            this.endpointGroupRegion(model.endpointGroupRegion);
            this.destinationDescriptions(model.destinationDescriptions);
            this.endpointDescriptions(model.endpointDescriptions);
        }

        public final String getEndpointGroupArn() {
            return this.endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final String getEndpointGroupRegion() {
            return this.endpointGroupRegion;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        @Override
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final List<CustomRoutingDestinationDescription.Builder> getDestinationDescriptions() {
            List<CustomRoutingDestinationDescription.Builder> result = CustomRoutingDestinationDescriptionsCopier.copyToBuilder(this.destinationDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationDescriptions(Collection<CustomRoutingDestinationDescription.BuilderImpl> destinationDescriptions) {
            this.destinationDescriptions = CustomRoutingDestinationDescriptionsCopier.copyFromBuilder(destinationDescriptions);
        }

        @Override
        public final Builder destinationDescriptions(Collection<CustomRoutingDestinationDescription> destinationDescriptions) {
            this.destinationDescriptions = CustomRoutingDestinationDescriptionsCopier.copy(destinationDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationDescriptions(CustomRoutingDestinationDescription ... destinationDescriptions) {
            this.destinationDescriptions(Arrays.asList(destinationDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationDescriptions(Consumer<CustomRoutingDestinationDescription.Builder> ... destinationDescriptions) {
            this.destinationDescriptions(Stream.of(destinationDescriptions).map(c -> (CustomRoutingDestinationDescription)((CustomRoutingDestinationDescription.Builder)CustomRoutingDestinationDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CustomRoutingEndpointDescription.Builder> getEndpointDescriptions() {
            List<CustomRoutingEndpointDescription.Builder> result = CustomRoutingEndpointDescriptionsCopier.copyToBuilder(this.endpointDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointDescriptions(Collection<CustomRoutingEndpointDescription.BuilderImpl> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copyFromBuilder(endpointDescriptions);
        }

        @Override
        public final Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copy(endpointDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(CustomRoutingEndpointDescription ... endpointDescriptions) {
            this.endpointDescriptions(Arrays.asList(endpointDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder> ... endpointDescriptions) {
            this.endpointDescriptions(Stream.of(endpointDescriptions).map(c -> (CustomRoutingEndpointDescription)((CustomRoutingEndpointDescription.Builder)CustomRoutingEndpointDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CustomRoutingEndpointGroup build() {
            return new CustomRoutingEndpointGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomRoutingEndpointGroup> {
        public Builder endpointGroupArn(String var1);

        public Builder endpointGroupRegion(String var1);

        public Builder destinationDescriptions(Collection<CustomRoutingDestinationDescription> var1);

        public Builder destinationDescriptions(CustomRoutingDestinationDescription ... var1);

        public Builder destinationDescriptions(Consumer<CustomRoutingDestinationDescription.Builder> ... var1);

        public Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> var1);

        public Builder endpointDescriptions(CustomRoutingEndpointDescription ... var1);

        public Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder> ... var1);
    }
}

