/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.globalaccelerator.model.HealthState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointDescription> {
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(EndpointDescription.getter(EndpointDescription::endpointId)).setter(EndpointDescription.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Weight").getter(EndpointDescription.getter(EndpointDescription::weight)).setter(EndpointDescription.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final SdkField<String> HEALTH_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthState").getter(EndpointDescription.getter(EndpointDescription::healthStateAsString)).setter(EndpointDescription.setter(Builder::healthState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthState").build()}).build();
    private static final SdkField<String> HEALTH_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthReason").getter(EndpointDescription.getter(EndpointDescription::healthReason)).setter(EndpointDescription.setter(Builder::healthReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthReason").build()}).build();
    private static final SdkField<Boolean> CLIENT_IP_PRESERVATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ClientIPPreservationEnabled").getter(EndpointDescription.getter(EndpointDescription::clientIPPreservationEnabled)).setter(EndpointDescription.setter(Builder::clientIPPreservationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIPPreservationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ID_FIELD, WEIGHT_FIELD, HEALTH_STATE_FIELD, HEALTH_REASON_FIELD, CLIENT_IP_PRESERVATION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpointId;
    private final Integer weight;
    private final String healthState;
    private final String healthReason;
    private final Boolean clientIPPreservationEnabled;

    private EndpointDescription(BuilderImpl builder) {
        this.endpointId = builder.endpointId;
        this.weight = builder.weight;
        this.healthState = builder.healthState;
        this.healthReason = builder.healthReason;
        this.clientIPPreservationEnabled = builder.clientIPPreservationEnabled;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final Integer weight() {
        return this.weight;
    }

    public final HealthState healthState() {
        return HealthState.fromValue(this.healthState);
    }

    public final String healthStateAsString() {
        return this.healthState;
    }

    public final String healthReason() {
        return this.healthReason;
    }

    public final Boolean clientIPPreservationEnabled() {
        return this.clientIPPreservationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIPPreservationEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDescription)) {
            return false;
        }
        EndpointDescription other = (EndpointDescription)obj;
        return Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.weight(), other.weight()) && Objects.equals(this.healthStateAsString(), other.healthStateAsString()) && Objects.equals(this.healthReason(), other.healthReason()) && Objects.equals(this.clientIPPreservationEnabled(), other.clientIPPreservationEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointDescription").add("EndpointId", (Object)this.endpointId()).add("Weight", (Object)this.weight()).add("HealthState", (Object)this.healthStateAsString()).add("HealthReason", (Object)this.healthReason()).add("ClientIPPreservationEnabled", (Object)this.clientIPPreservationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
            case "HealthState": {
                return Optional.ofNullable(clazz.cast(this.healthStateAsString()));
            }
            case "HealthReason": {
                return Optional.ofNullable(clazz.cast(this.healthReason()));
            }
            case "ClientIPPreservationEnabled": {
                return Optional.ofNullable(clazz.cast(this.clientIPPreservationEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        map.put("HealthState", HEALTH_STATE_FIELD);
        map.put("HealthReason", HEALTH_REASON_FIELD);
        map.put("ClientIPPreservationEnabled", CLIENT_IP_PRESERVATION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointDescription, T> g) {
        return obj -> g.apply((EndpointDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointId;
        private Integer weight;
        private String healthState;
        private String healthReason;
        private Boolean clientIPPreservationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDescription model) {
            this.endpointId(model.endpointId);
            this.weight(model.weight);
            this.healthState(model.healthState);
            this.healthReason(model.healthReason);
            this.clientIPPreservationEnabled(model.clientIPPreservationEnabled);
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final Integer getWeight() {
            return this.weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final String getHealthState() {
            return this.healthState;
        }

        public final void setHealthState(String healthState) {
            this.healthState = healthState;
        }

        @Override
        public final Builder healthState(String healthState) {
            this.healthState = healthState;
            return this;
        }

        @Override
        public final Builder healthState(HealthState healthState) {
            this.healthState(healthState == null ? null : healthState.toString());
            return this;
        }

        public final String getHealthReason() {
            return this.healthReason;
        }

        public final void setHealthReason(String healthReason) {
            this.healthReason = healthReason;
        }

        @Override
        public final Builder healthReason(String healthReason) {
            this.healthReason = healthReason;
            return this;
        }

        public final Boolean getClientIPPreservationEnabled() {
            return this.clientIPPreservationEnabled;
        }

        public final void setClientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
        }

        @Override
        public final Builder clientIPPreservationEnabled(Boolean clientIPPreservationEnabled) {
            this.clientIPPreservationEnabled = clientIPPreservationEnabled;
            return this;
        }

        public EndpointDescription build() {
            return new EndpointDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointDescription> {
        public Builder endpointId(String var1);

        public Builder weight(Integer var1);

        public Builder healthState(String var1);

        public Builder healthState(HealthState var1);

        public Builder healthReason(String var1);

        public Builder clientIPPreservationEnabled(Boolean var1);
    }
}

