/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotDisabledException;
import software.amazon.awssdk.services.globalaccelerator.model.AcceleratorNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AccessDeniedException;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AddEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AdvertiseByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedEndpointGroupFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.AssociatedListenerFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ByoipCidrNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ConflictException;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.CreateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeleteListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DeprovisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.DescribeListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupAlreadyExistsException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointGroupNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.EndpointNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.GlobalAcceleratorException;
import software.amazon.awssdk.services.globalaccelerator.model.IncorrectCidrStateException;
import software.amazon.awssdk.services.globalaccelerator.model.InternalServiceErrorException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidArgumentException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidNextTokenException;
import software.amazon.awssdk.services.globalaccelerator.model.InvalidPortRangeException;
import software.amazon.awssdk.services.globalaccelerator.model.LimitExceededException;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListByoipCidrsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListEndpointGroupsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListListenersResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.ListenerNotFoundException;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ProvisionByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.RemoveEndpointsResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.TagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.TransactionInProgressException;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UntagResourceResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateEndpointGroupResponse;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerRequest;
import software.amazon.awssdk.services.globalaccelerator.model.UpdateListenerResponse;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrRequest;
import software.amazon.awssdk.services.globalaccelerator.model.WithdrawByoipCidrResponse;
import software.amazon.awssdk.services.globalaccelerator.transform.AddCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AddEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AdvertiseByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.AllowCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DenyCustomRoutingTrafficRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DeprovisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.DescribeListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListByoipCidrsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingAcceleratorsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsByDestinationRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListCustomRoutingPortMappingsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListEndpointGroupsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListListenersRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.ProvisionByoipCidrRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveCustomRoutingEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.RemoveEndpointsRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorAttributesRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingAcceleratorRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateCustomRoutingListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateEndpointGroupRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.UpdateListenerRequestMarshaller;
import software.amazon.awssdk.services.globalaccelerator.transform.WithdrawByoipCidrRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link GlobalAcceleratorClient}.
 *
 * @see GlobalAcceleratorClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGlobalAcceleratorClient implements GlobalAcceleratorClient {
    private static final Logger log = Logger.loggerFor(DefaultGlobalAcceleratorClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration;

    protected DefaultGlobalAcceleratorClient(GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     * </p>
     * <p>
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your
     * subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For
     * example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     * </p>
     * <p>
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail
     * with a LimitExceededException.
     * </p>
     * <p>
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all
     * destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     *
     * @param addCustomRoutingEndpointsRequest
     * @return Result of the AddCustomRoutingEndpoints operation returned by the service.
     * @throws EndpointAlreadyExistsException
     *         The endpoint that you specified doesn't exist.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ConflictException
     *         You can't use both of those options.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AddCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddCustomRoutingEndpointsResponse addCustomRoutingEndpoints(
            AddCustomRoutingEndpointsRequest addCustomRoutingEndpointsRequest) throws EndpointAlreadyExistsException,
            EndpointGroupNotFoundException, InternalServiceErrorException, InvalidArgumentException, LimitExceededException,
            AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddCustomRoutingEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddCustomRoutingEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addCustomRoutingEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddCustomRoutingEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<AddCustomRoutingEndpointsRequest, AddCustomRoutingEndpointsResponse>()
                            .withOperationName("AddCustomRoutingEndpoints").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addCustomRoutingEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddCustomRoutingEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add endpoints to an endpoint group. The <code>AddEndpoints</code> API operation is the recommended option for
     * adding endpoints. The alternative options are to add endpoints when you create an endpoint group (with the <a
     * href
     * ="https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html">CreateEndpointGroup</a>
     * API) or when you update an endpoint group (with the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html"
     * >UpdateEndpointGroup</a> API).
     * </p>
     * <p>
     * There are two advantages to using <code>AddEndpoints</code> to add endpoints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It's faster, because Global Accelerator only has to resolve the new endpoints that you're adding.
     * </p>
     * </li>
     * <li>
     * <p>
     * It's more convenient, because you don't need to specify all of the current endpoints that are already in the
     * endpoint group in addition to the new endpoints that you want to add.
     * </p>
     * </li>
     * </ul>
     *
     * @param addEndpointsRequest
     * @return Result of the AddEndpoints operation returned by the service.
     * @throws TransactionInProgressException
     *         There's already a transaction in progress. Another transaction can't be processed.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AddEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AddEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddEndpointsResponse addEndpoints(AddEndpointsRequest addEndpointsRequest) throws TransactionInProgressException,
            EndpointGroupNotFoundException, InternalServiceErrorException, InvalidArgumentException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddEndpoints");

            return clientHandler.execute(new ClientExecutionParams<AddEndpointsRequest, AddEndpointsResponse>()
                    .withOperationName("AddEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts
     * routing to Amazon Web Services because of propagation delays.
     * </p>
     * <p>
     * To stop advertising the BYOIP address range, use <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html"> WithdrawByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param advertiseByoipCidrRequest
     * @return Result of the AdvertiseByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AdvertiseByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AdvertiseByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AdvertiseByoipCidrResponse advertiseByoipCidr(AdvertiseByoipCidrRequest advertiseByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AdvertiseByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AdvertiseByoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, advertiseByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AdvertiseByoipCidr");

            return clientHandler.execute(new ClientExecutionParams<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse>()
                    .withOperationName("AdvertiseByoipCidr").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(advertiseByoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AdvertiseByoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive
     * traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or
     * allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot
     * specify IP addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param allowCustomRoutingTrafficRequest
     * @return Result of the AllowCustomRoutingTraffic operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.AllowCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/AllowCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AllowCustomRoutingTrafficResponse allowCustomRoutingTraffic(
            AllowCustomRoutingTrafficRequest allowCustomRoutingTrafficRequest) throws EndpointGroupNotFoundException,
            InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AllowCustomRoutingTrafficResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AllowCustomRoutingTrafficResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, allowCustomRoutingTrafficRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AllowCustomRoutingTraffic");

            return clientHandler
                    .execute(new ClientExecutionParams<AllowCustomRoutingTrafficRequest, AllowCustomRoutingTrafficResponse>()
                            .withOperationName("AllowCustomRoutingTraffic").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(allowCustomRoutingTrafficRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AllowCustomRoutingTrafficRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct
     * traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param createAcceleratorRequest
     * @return Result of the CreateAccelerator operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAcceleratorResponse createAccelerator(CreateAcceleratorRequest createAcceleratorRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccelerator");

            return clientHandler.execute(new ClientExecutionParams<CreateAcceleratorRequest, CreateAcceleratorResponse>()
                    .withOperationName("CreateAccelerator").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAcceleratorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of
     * Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     * </p>
     * <p>
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To
     * enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see
     * the <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html">
     * AllowCustomRoutingTraffic</a> operation.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param createCustomRoutingAcceleratorRequest
     * @return Result of the CreateCustomRoutingAccelerator operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCustomRoutingAcceleratorResponse createCustomRoutingAccelerator(
            CreateCustomRoutingAcceleratorRequest createCustomRoutingAcceleratorRequest) throws InternalServiceErrorException,
            InvalidArgumentException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomRoutingAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomRoutingAccelerator");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCustomRoutingAcceleratorRequest, CreateCustomRoutingAcceleratorResponse>()
                            .withOperationName("CreateCustomRoutingAccelerator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createCustomRoutingAcceleratorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCustomRoutingAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a
     * collection of endpoints in one Amazon Web Services Region.
     * </p>
     *
     * @param createCustomRoutingEndpointGroupRequest
     * @return Result of the CreateCustomRoutingEndpointGroup operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws EndpointGroupAlreadyExistsException
     *         The endpoint group that you specified already exists.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCustomRoutingEndpointGroupResponse createCustomRoutingEndpointGroup(
            CreateCustomRoutingEndpointGroupRequest createCustomRoutingEndpointGroupRequest) throws AcceleratorNotFoundException,
            EndpointGroupAlreadyExistsException, ListenerNotFoundException, InternalServiceErrorException,
            InvalidArgumentException, InvalidPortRangeException, LimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomRoutingEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomRoutingEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomRoutingEndpointGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCustomRoutingEndpointGroupRequest, CreateCustomRoutingEndpointGroupResponse>()
                            .withOperationName("CreateCustomRoutingEndpointGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createCustomRoutingEndpointGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCustomRoutingEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive
     * to assigned static IP addresses on the port range that you specify.
     * </p>
     *
     * @param createCustomRoutingListenerRequest
     * @return Result of the CreateCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCustomRoutingListenerResponse createCustomRoutingListener(
            CreateCustomRoutingListenerRequest createCustomRoutingListenerRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomRoutingListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomRoutingListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomRoutingListener");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCustomRoutingListenerRequest, CreateCustomRoutingListenerResponse>()
                            .withOperationName("CreateCustomRoutingListener").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createCustomRoutingListenerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCustomRoutingListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon
     * Web Services Region. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param createEndpointGroupRequest
     * @return Result of the CreateEndpointGroup operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws EndpointGroupAlreadyExistsException
     *         The endpoint group that you specified already exists.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEndpointGroupResponse createEndpointGroup(CreateEndpointGroupRequest createEndpointGroupRequest)
            throws AcceleratorNotFoundException, EndpointGroupAlreadyExistsException, ListenerNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpointGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateEndpointGroupRequest, CreateEndpointGroupResponse>()
                    .withOperationName("CreateEndpointGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createEndpointGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned
     * static IP addresses on a port, port range, or list of port ranges that you specify.
     * </p>
     *
     * @param createListenerRequest
     * @return Result of the CreateListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidPortRangeException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateListenerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateListener");

            return clientHandler.execute(new ClientExecutionParams<CreateListenerRequest, CreateListenerResponse>()
                    .withOperationName("CreateListener").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent
     * resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP
     * addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses
     * from those ranges.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteAcceleratorRequest
     * @return Result of the DeleteAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AcceleratorNotDisabledException
     *         The accelerator that you specified could not be disabled.
     * @throws AssociatedListenerFoundException
     *         The accelerator that you specified has a listener associated with it. You must remove all dependent
     *         resources from an accelerator before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAcceleratorResponse deleteAccelerator(DeleteAcceleratorRequest deleteAcceleratorRequest)
            throws AcceleratorNotFoundException, AcceleratorNotDisabledException, AssociatedListenerFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccelerator");

            return clientHandler.execute(new ClientExecutionParams<DeleteAcceleratorRequest, DeleteAcceleratorResponse>()
                    .withOperationName("DeleteAccelerator").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAcceleratorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all
     * dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set
     * <code>Enabled</code> to false.
     * </p>
     * <important>
     * <p>
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two
     * static IP addresses.
     * </p>
     * <p>
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator
     * and it no longer accepts or routes traffic. However, when you <i>delete</i> an accelerator, you lose the static
     * IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best
     * practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM
     * policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html">Identity and access
     * management</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     * </important>
     *
     * @param deleteCustomRoutingAcceleratorRequest
     * @return Result of the DeleteCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AcceleratorNotDisabledException
     *         The accelerator that you specified could not be disabled.
     * @throws AssociatedListenerFoundException
     *         The accelerator that you specified has a listener associated with it. You must remove all dependent
     *         resources from an accelerator before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomRoutingAcceleratorResponse deleteCustomRoutingAccelerator(
            DeleteCustomRoutingAcceleratorRequest deleteCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException,
            AcceleratorNotDisabledException, AssociatedListenerFoundException, InternalServiceErrorException,
            InvalidArgumentException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomRoutingAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomRoutingAccelerator");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomRoutingAcceleratorRequest, DeleteCustomRoutingAcceleratorResponse>()
                            .withOperationName("DeleteCustomRoutingAccelerator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteCustomRoutingAcceleratorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCustomRoutingAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an endpoint group from a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingEndpointGroupRequest
     * @return Result of the DeleteCustomRoutingEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomRoutingEndpointGroupResponse deleteCustomRoutingEndpointGroup(
            DeleteCustomRoutingEndpointGroupRequest deleteCustomRoutingEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomRoutingEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomRoutingEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomRoutingEndpointGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomRoutingEndpointGroupRequest, DeleteCustomRoutingEndpointGroupResponse>()
                            .withOperationName("DeleteCustomRoutingEndpointGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteCustomRoutingEndpointGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCustomRoutingEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a listener for a custom routing accelerator.
     * </p>
     *
     * @param deleteCustomRoutingListenerRequest
     * @return Result of the DeleteCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws AssociatedEndpointGroupFoundException
     *         The listener that you specified has an endpoint group associated with it. You must remove all dependent
     *         resources from a listener before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCustomRoutingListenerResponse deleteCustomRoutingListener(
            DeleteCustomRoutingListenerRequest deleteCustomRoutingListenerRequest) throws InvalidArgumentException,
            ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomRoutingListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomRoutingListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomRoutingListener");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCustomRoutingListenerRequest, DeleteCustomRoutingListenerResponse>()
                            .withOperationName("DeleteCustomRoutingListener").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteCustomRoutingListenerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteCustomRoutingListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an endpoint group from a listener.
     * </p>
     *
     * @param deleteEndpointGroupRequest
     * @return Result of the DeleteEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEndpointGroupResponse deleteEndpointGroup(DeleteEndpointGroupRequest deleteEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpointGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteEndpointGroupRequest, DeleteEndpointGroupResponse>()
                    .withOperationName("DeleteEndpointGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteEndpointGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a listener from an accelerator.
     * </p>
     *
     * @param deleteListenerRequest
     * @return Result of the DeleteListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws AssociatedEndpointGroupFoundException
     *         The listener that you specified has an endpoint group associated with it. You must remove all dependent
     *         resources from a listener before you can delete it.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws InvalidArgumentException,
            ListenerNotFoundException, AssociatedEndpointGroupFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteListenerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteListener");

            return clientHandler.execute(new ClientExecutionParams<DeleteListenerRequest, DeleteListenerResponse>()
                    .withOperationName("DeleteListener").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot
     * receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint,
     * or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP
     * addresses or ports outside of the range that you configured for the endpoint group.
     * </p>
     * <p>
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator:
     * the status changes from IN_PROGRESS to DEPLOYED.
     * </p>
     *
     * @param denyCustomRoutingTrafficRequest
     * @return Result of the DenyCustomRoutingTraffic operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DenyCustomRoutingTraffic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DenyCustomRoutingTraffic"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DenyCustomRoutingTrafficResponse denyCustomRoutingTraffic(
            DenyCustomRoutingTrafficRequest denyCustomRoutingTrafficRequest) throws EndpointGroupNotFoundException,
            InvalidArgumentException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DenyCustomRoutingTrafficResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DenyCustomRoutingTrafficResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, denyCustomRoutingTrafficRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DenyCustomRoutingTraffic");

            return clientHandler
                    .execute(new ClientExecutionParams<DenyCustomRoutingTrafficRequest, DenyCustomRoutingTrafficResponse>()
                            .withOperationName("DenyCustomRoutingTraffic").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(denyCustomRoutingTrafficRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DenyCustomRoutingTrafficRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through
     * bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     * </p>
     * <p>
     * Before you can release an address range, you must stop advertising it by using <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html">WithdrawByoipCidr</a> and
     * you must not have any accelerators that are using static IP addresses allocated from its address range.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param deprovisionByoipCidrRequest
     * @return Result of the DeprovisionByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DeprovisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DeprovisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeprovisionByoipCidrResponse deprovisionByoipCidr(DeprovisionByoipCidrRequest deprovisionByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeprovisionByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeprovisionByoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprovisionByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprovisionByoipCidr");

            return clientHandler.execute(new ClientExecutionParams<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse>()
                    .withOperationName("DeprovisionByoipCidr").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deprovisionByoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeprovisionByoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe an accelerator.
     * </p>
     *
     * @param describeAcceleratorRequest
     * @return Result of the DescribeAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAcceleratorResponse describeAccelerator(DescribeAcceleratorRequest describeAcceleratorRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccelerator");

            return clientHandler.execute(new ClientExecutionParams<DescribeAcceleratorRequest, DescribeAcceleratorResponse>()
                    .withOperationName("DescribeAccelerator").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAcceleratorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe the attributes of an accelerator.
     * </p>
     *
     * @param describeAcceleratorAttributesRequest
     * @return Result of the DescribeAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAcceleratorAttributesResponse describeAcceleratorAttributes(
            DescribeAcceleratorAttributesRequest describeAcceleratorAttributesRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAcceleratorAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAcceleratorAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAcceleratorAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAcceleratorAttributesRequest, DescribeAcceleratorAttributesResponse>()
                            .withOperationName("DescribeAcceleratorAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAcceleratorAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAcceleratorAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorRequest
     * @return Result of the DescribeCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomRoutingAcceleratorResponse describeCustomRoutingAccelerator(
            DescribeCustomRoutingAcceleratorRequest describeCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomRoutingAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingAccelerator");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingAcceleratorRequest, DescribeCustomRoutingAcceleratorResponse>()
                            .withOperationName("DescribeCustomRoutingAccelerator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeCustomRoutingAcceleratorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomRoutingAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe the attributes of a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingAcceleratorAttributesRequest
     * @return Result of the DescribeCustomRoutingAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomRoutingAcceleratorAttributesResponse describeCustomRoutingAcceleratorAttributes(
            DescribeCustomRoutingAcceleratorAttributesRequest describeCustomRoutingAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomRoutingAcceleratorAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeCustomRoutingAcceleratorAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingAcceleratorAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingAcceleratorAttributesRequest, DescribeCustomRoutingAcceleratorAttributesResponse>()
                            .withOperationName("DescribeCustomRoutingAcceleratorAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeCustomRoutingAcceleratorAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomRoutingAcceleratorAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe an endpoint group for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingEndpointGroupRequest
     * @return Result of the DescribeCustomRoutingEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingEndpointGroup
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomRoutingEndpointGroupResponse describeCustomRoutingEndpointGroup(
            DescribeCustomRoutingEndpointGroupRequest describeCustomRoutingEndpointGroupRequest) throws InvalidArgumentException,
            EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomRoutingEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomRoutingEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingEndpointGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingEndpointGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingEndpointGroupRequest, DescribeCustomRoutingEndpointGroupResponse>()
                            .withOperationName("DescribeCustomRoutingEndpointGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeCustomRoutingEndpointGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomRoutingEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The description of a listener for a custom routing accelerator.
     * </p>
     *
     * @param describeCustomRoutingListenerRequest
     * @return Result of the DescribeCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomRoutingListenerResponse describeCustomRoutingListener(
            DescribeCustomRoutingListenerRequest describeCustomRoutingListenerRequest) throws InvalidArgumentException,
            ListenerNotFoundException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomRoutingListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomRoutingListenerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomRoutingListener");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomRoutingListenerRequest, DescribeCustomRoutingListenerResponse>()
                            .withOperationName("DescribeCustomRoutingListener").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeCustomRoutingListenerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomRoutingListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe an endpoint group.
     * </p>
     *
     * @param describeEndpointGroupRequest
     * @return Result of the DescribeEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEndpointGroupResponse describeEndpointGroup(DescribeEndpointGroupRequest describeEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeEndpointGroupRequest, DescribeEndpointGroupResponse>()
                    .withOperationName("DescribeEndpointGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe a listener.
     * </p>
     *
     * @param describeListenerRequest
     * @return Result of the DescribeListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.DescribeListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/DescribeListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeListenerResponse describeListener(DescribeListenerRequest describeListenerRequest)
            throws InvalidArgumentException, ListenerNotFoundException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeListenerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListener");

            return clientHandler.execute(new ClientExecutionParams<DescribeListenerRequest, DescribeListenerResponse>()
                    .withOperationName("DescribeListener").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listAcceleratorsRequest
     * @return Result of the ListAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAcceleratorsResponse listAccelerators(ListAcceleratorsRequest listAcceleratorsRequest)
            throws InvalidArgumentException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAcceleratorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAcceleratorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAcceleratorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccelerators");

            return clientHandler.execute(new ClientExecutionParams<ListAcceleratorsRequest, ListAcceleratorsResponse>()
                    .withOperationName("ListAccelerators").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAcceleratorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAcceleratorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IP address ranges that were specified in calls to <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html">ProvisionByoipCidr</a>,
     * including the current state and a history of state changes.
     * </p>
     *
     * @param listByoipCidrsRequest
     * @return Result of the ListByoipCidrs operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListByoipCidrs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListByoipCidrsResponse listByoipCidrs(ListByoipCidrsRequest listByoipCidrsRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListByoipCidrsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListByoipCidrsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listByoipCidrsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListByoipCidrs");

            return clientHandler.execute(new ClientExecutionParams<ListByoipCidrsRequest, ListByoipCidrsResponse>()
                    .withOperationName("ListByoipCidrs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listByoipCidrsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListByoipCidrsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the custom routing accelerators for an Amazon Web Services account.
     * </p>
     *
     * @param listCustomRoutingAcceleratorsRequest
     * @return Result of the ListCustomRoutingAccelerators operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingAccelerators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingAccelerators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomRoutingAcceleratorsResponse listCustomRoutingAccelerators(
            ListCustomRoutingAcceleratorsRequest listCustomRoutingAcceleratorsRequest) throws InvalidArgumentException,
            InvalidNextTokenException, InternalServiceErrorException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomRoutingAcceleratorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCustomRoutingAcceleratorsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingAcceleratorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingAccelerators");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingAcceleratorsRequest, ListCustomRoutingAcceleratorsResponse>()
                            .withOperationName("ListCustomRoutingAccelerators").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCustomRoutingAcceleratorsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCustomRoutingAcceleratorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingEndpointGroupsRequest
     * @return Result of the ListCustomRoutingEndpointGroups operation returned by the service.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingEndpointGroups
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomRoutingEndpointGroupsResponse listCustomRoutingEndpointGroups(
            ListCustomRoutingEndpointGroupsRequest listCustomRoutingEndpointGroupsRequest) throws ListenerNotFoundException,
            InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomRoutingEndpointGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCustomRoutingEndpointGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingEndpointGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingEndpointGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingEndpointGroupsRequest, ListCustomRoutingEndpointGroupsResponse>()
                            .withOperationName("ListCustomRoutingEndpointGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCustomRoutingEndpointGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCustomRoutingEndpointGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the listeners for a custom routing accelerator.
     * </p>
     *
     * @param listCustomRoutingListenersRequest
     * @return Result of the ListCustomRoutingListeners operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomRoutingListenersResponse listCustomRoutingListeners(
            ListCustomRoutingListenersRequest listCustomRoutingListenersRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomRoutingListenersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCustomRoutingListenersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomRoutingListenersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingListeners");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingListenersRequest, ListCustomRoutingListenersResponse>()
                            .withOperationName("ListCustomRoutingListeners").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCustomRoutingListenersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCustomRoutingListenersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP
     * addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each
     * subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port
     * mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on
     * your servers.
     * </p>
     * <p>
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add
     * a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If
     * you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created
     * when you add the subnet to Global Accelerator.
     * </p>
     * <p>
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are
     * allowed or denied traffic.
     * </p>
     *
     * @param listCustomRoutingPortMappingsRequest
     * @return Result of the ListCustomRoutingPortMappings operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomRoutingPortMappingsResponse listCustomRoutingPortMappings(
            ListCustomRoutingPortMappingsRequest listCustomRoutingPortMappingsRequest) throws InvalidArgumentException,
            InvalidNextTokenException, EndpointGroupNotFoundException, AcceleratorNotFoundException,
            InternalServiceErrorException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomRoutingPortMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCustomRoutingPortMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingPortMappingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingPortMappings");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingPortMappingsRequest, ListCustomRoutingPortMappingsResponse>()
                            .withOperationName("ListCustomRoutingPortMappings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCustomRoutingPortMappingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCustomRoutingPortMappingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the
     * mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple
     * custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a
     * specific destination instance.
     * </p>
     *
     * @param listCustomRoutingPortMappingsByDestinationRequest
     * @return Result of the ListCustomRoutingPortMappingsByDestination operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListCustomRoutingPortMappingsByDestination
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListCustomRoutingPortMappingsByDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCustomRoutingPortMappingsByDestinationResponse listCustomRoutingPortMappingsByDestination(
            ListCustomRoutingPortMappingsByDestinationRequest listCustomRoutingPortMappingsByDestinationRequest)
            throws InvalidArgumentException, InvalidNextTokenException, EndpointNotFoundException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomRoutingPortMappingsByDestinationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListCustomRoutingPortMappingsByDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCustomRoutingPortMappingsByDestinationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomRoutingPortMappingsByDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCustomRoutingPortMappingsByDestinationRequest, ListCustomRoutingPortMappingsByDestinationResponse>()
                            .withOperationName("ListCustomRoutingPortMappingsByDestination").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(listCustomRoutingPortMappingsByDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCustomRoutingPortMappingsByDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the endpoint groups that are associated with a listener.
     * </p>
     *
     * @param listEndpointGroupsRequest
     * @return Result of the ListEndpointGroups operation returned by the service.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListEndpointGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListEndpointGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEndpointGroupsResponse listEndpointGroups(ListEndpointGroupsRequest listEndpointGroupsRequest)
            throws ListenerNotFoundException, InvalidNextTokenException, InvalidArgumentException, InternalServiceErrorException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEndpointGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEndpointGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEndpointGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEndpointGroups");

            return clientHandler.execute(new ClientExecutionParams<ListEndpointGroupsRequest, ListEndpointGroupsResponse>()
                    .withOperationName("ListEndpointGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEndpointGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEndpointGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the listeners for an accelerator.
     * </p>
     *
     * @param listListenersRequest
     * @return Result of the ListListeners operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InvalidNextTokenException
     *         There isn't another item to return.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListListenersResponse listListeners(ListListenersRequest listListenersRequest) throws InvalidArgumentException,
            AcceleratorNotFoundException, InvalidNextTokenException, InternalServiceErrorException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListListenersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListListenersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listListenersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListListeners");

            return clientHandler.execute(new ClientExecutionParams<ListListenersRequest, ListListenersResponse>()
                    .withOperationName("ListListeners").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listListenersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListListenersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all tags for an accelerator.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses
     * (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be
     * advertised using <a href="https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html">
     * AdvertiseByoipCidr</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param provisionByoipCidrRequest
     * @return Result of the ProvisionByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.ProvisionByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ProvisionByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ProvisionByoipCidrResponse provisionByoipCidr(ProvisionByoipCidrRequest provisionByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, LimitExceededException, AccessDeniedException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ProvisionByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ProvisionByoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, provisionByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionByoipCidr");

            return clientHandler.execute(new ClientExecutionParams<ProvisionByoipCidrRequest, ProvisionByoipCidrResponse>()
                    .withOperationName("ProvisionByoipCidr").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(provisionByoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ProvisionByoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove endpoints from a custom routing accelerator.
     * </p>
     *
     * @param removeCustomRoutingEndpointsRequest
     * @return Result of the RemoveCustomRoutingEndpoints operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws EndpointNotFoundException
     *         The endpoint that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ConflictException
     *         You can't use both of those options.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.RemoveCustomRoutingEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveCustomRoutingEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveCustomRoutingEndpointsResponse removeCustomRoutingEndpoints(
            RemoveCustomRoutingEndpointsRequest removeCustomRoutingEndpointsRequest) throws EndpointGroupNotFoundException,
            EndpointNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException,
            ConflictException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveCustomRoutingEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveCustomRoutingEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeCustomRoutingEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveCustomRoutingEndpoints");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveCustomRoutingEndpointsRequest, RemoveCustomRoutingEndpointsResponse>()
                            .withOperationName("RemoveCustomRoutingEndpoints").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeCustomRoutingEndpointsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveCustomRoutingEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove endpoints from an endpoint group.
     * </p>
     * <p>
     * The <code>RemoveEndpoints</code> API operation is the recommended option for removing endpoints. The alternative
     * is to remove endpoints by updating an endpoint group by using the <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html"
     * >UpdateEndpointGroup</a> API operation. There are two advantages to using <code>AddEndpoints</code> to remove
     * endpoints instead:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It's more convenient, because you only need to specify the endpoints that you want to remove. With the
     * <code>UpdateEndpointGroup</code> API operation, you must specify all of the endpoints in the endpoint group
     * except the ones that you want to remove from the group.
     * </p>
     * </li>
     * <li>
     * <p>
     * It's faster, because Global Accelerator doesn't need to resolve any endpoints. With the
     * <code>UpdateEndpointGroup</code> API operation, Global Accelerator must resolve all of the endpoints that remain
     * in the group.
     * </p>
     * </li>
     * </ul>
     *
     * @param removeEndpointsRequest
     * @return Result of the RemoveEndpoints operation returned by the service.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws TransactionInProgressException
     *         There's already a transaction in progress. Another transaction can't be processed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.RemoveEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/RemoveEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveEndpointsResponse removeEndpoints(RemoveEndpointsRequest removeEndpointsRequest)
            throws EndpointGroupNotFoundException, InternalServiceErrorException, InvalidArgumentException,
            AccessDeniedException, TransactionInProgressException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveEndpoints");

            return clientHandler.execute(new ClientExecutionParams<RemoveEndpointsRequest, RemoveEndpointsResponse>()
                    .withOperationName("RemoveEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(removeEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add tags to an accelerator resource.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and
     * its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was
     * already removed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html">Tagging in
     * Global Accelerator</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an accelerator.
     * </p>
     * <important>
     * <p>
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you
     * must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for
     * example, specify <code>--region us-west-2</code> on AWS CLI commands.
     * </p>
     * </important>
     *
     * @param updateAcceleratorRequest
     * @return Result of the UpdateAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateAccelerator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAcceleratorResponse updateAccelerator(UpdateAcceleratorRequest updateAcceleratorRequest)
            throws AcceleratorNotFoundException, AccessDeniedException, InternalServiceErrorException, InvalidArgumentException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAcceleratorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccelerator");

            return clientHandler.execute(new ClientExecutionParams<UpdateAcceleratorRequest, UpdateAcceleratorResponse>()
                    .withOperationName("UpdateAccelerator").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAcceleratorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the attributes for an accelerator.
     * </p>
     *
     * @param updateAcceleratorAttributesRequest
     * @return Result of the UpdateAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateAcceleratorAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAcceleratorAttributesResponse updateAcceleratorAttributes(
            UpdateAcceleratorAttributesRequest updateAcceleratorAttributesRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAcceleratorAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAcceleratorAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAcceleratorAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAcceleratorAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAcceleratorAttributesRequest, UpdateAcceleratorAttributesResponse>()
                            .withOperationName("UpdateAcceleratorAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateAcceleratorAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAcceleratorAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorRequest
     * @return Result of the UpdateCustomRoutingAccelerator operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingAccelerator
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAccelerator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCustomRoutingAcceleratorResponse updateCustomRoutingAccelerator(
            UpdateCustomRoutingAcceleratorRequest updateCustomRoutingAcceleratorRequest) throws AcceleratorNotFoundException,
            InternalServiceErrorException, InvalidArgumentException, AwsServiceException, SdkClientException,
            GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCustomRoutingAcceleratorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCustomRoutingAcceleratorResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCustomRoutingAcceleratorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomRoutingAccelerator");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomRoutingAcceleratorRequest, UpdateCustomRoutingAcceleratorResponse>()
                            .withOperationName("UpdateCustomRoutingAccelerator").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateCustomRoutingAcceleratorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCustomRoutingAcceleratorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the attributes for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingAcceleratorAttributesRequest
     * @return Result of the UpdateCustomRoutingAcceleratorAttributes operation returned by the service.
     * @throws AcceleratorNotFoundException
     *         The accelerator that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingAcceleratorAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingAcceleratorAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCustomRoutingAcceleratorAttributesResponse updateCustomRoutingAcceleratorAttributes(
            UpdateCustomRoutingAcceleratorAttributesRequest updateCustomRoutingAcceleratorAttributesRequest)
            throws AcceleratorNotFoundException, InternalServiceErrorException, InvalidArgumentException, AccessDeniedException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCustomRoutingAcceleratorAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, UpdateCustomRoutingAcceleratorAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCustomRoutingAcceleratorAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomRoutingAcceleratorAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomRoutingAcceleratorAttributesRequest, UpdateCustomRoutingAcceleratorAttributesResponse>()
                            .withOperationName("UpdateCustomRoutingAcceleratorAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateCustomRoutingAcceleratorAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCustomRoutingAcceleratorAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a listener for a custom routing accelerator.
     * </p>
     *
     * @param updateCustomRoutingListenerRequest
     * @return Result of the UpdateCustomRoutingListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateCustomRoutingListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateCustomRoutingListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCustomRoutingListenerResponse updateCustomRoutingListener(
            UpdateCustomRoutingListenerRequest updateCustomRoutingListenerRequest) throws InvalidArgumentException,
            InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCustomRoutingListenerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCustomRoutingListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCustomRoutingListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomRoutingListener");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCustomRoutingListenerRequest, UpdateCustomRoutingListenerResponse>()
                            .withOperationName("UpdateCustomRoutingListener").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateCustomRoutingListenerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateCustomRoutingListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     * </p>
     *
     * @param updateEndpointGroupRequest
     * @return Result of the UpdateEndpointGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws EndpointGroupNotFoundException
     *         The endpoint group that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateEndpointGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateEndpointGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEndpointGroupResponse updateEndpointGroup(UpdateEndpointGroupRequest updateEndpointGroupRequest)
            throws InvalidArgumentException, EndpointGroupNotFoundException, InternalServiceErrorException,
            LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEndpointGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEndpointGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEndpointGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEndpointGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateEndpointGroupRequest, UpdateEndpointGroupResponse>()
                    .withOperationName("UpdateEndpointGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateEndpointGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEndpointGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a listener.
     * </p>
     *
     * @param updateListenerRequest
     * @return Result of the UpdateListener operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws InvalidPortRangeException
     *         The port numbers that you specified are not valid numbers or are not unique for this accelerator.
     * @throws ListenerNotFoundException
     *         The listener that you specified doesn't exist.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws LimitExceededException
     *         Processing your request would cause you to exceed an Global Accelerator limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/UpdateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateListenerResponse updateListener(UpdateListenerRequest updateListenerRequest) throws InvalidArgumentException,
            InvalidPortRangeException, ListenerNotFoundException, InternalServiceErrorException, LimitExceededException,
            AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateListenerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateListener");

            return clientHandler.execute(new ClientExecutionParams<UpdateListenerRequest, UpdateListenerResponse>()
                    .withOperationName("UpdateListener").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most
     * once every 10 seconds, even if you specify different address ranges each time.
     * </p>
     * <p>
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because
     * of propagation delays.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html">Bring your own IP addresses
     * (BYOIP)</a> in the <i>Global Accelerator Developer Guide</i>.
     * </p>
     *
     * @param withdrawByoipCidrRequest
     * @return Result of the WithdrawByoipCidr operation returned by the service.
     * @throws InternalServiceErrorException
     *         There was an internal error for Global Accelerator.
     * @throws InvalidArgumentException
     *         An argument that you specified is invalid.
     * @throws AccessDeniedException
     *         You don't have access permission.
     * @throws ByoipCidrNotFoundException
     *         The CIDR that you specified was not found or is incorrect.
     * @throws IncorrectCidrStateException
     *         The CIDR that you specified is not valid for this action. For example, the state of the CIDR might be
     *         incorrect for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GlobalAcceleratorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GlobalAcceleratorClient.WithdrawByoipCidr
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/WithdrawByoipCidr"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public WithdrawByoipCidrResponse withdrawByoipCidr(WithdrawByoipCidrRequest withdrawByoipCidrRequest)
            throws InternalServiceErrorException, InvalidArgumentException, AccessDeniedException, ByoipCidrNotFoundException,
            IncorrectCidrStateException, AwsServiceException, SdkClientException, GlobalAcceleratorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<WithdrawByoipCidrResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                WithdrawByoipCidrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, withdrawByoipCidrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Global Accelerator");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "WithdrawByoipCidr");

            return clientHandler.execute(new ClientExecutionParams<WithdrawByoipCidrRequest, WithdrawByoipCidrResponse>()
                    .withOperationName("WithdrawByoipCidr").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(withdrawByoipCidrRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new WithdrawByoipCidrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GlobalAcceleratorException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointNotFoundException")
                                .exceptionBuilderSupplier(EndpointNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociatedListenerFoundException")
                                .exceptionBuilderSupplier(AssociatedListenerFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociatedEndpointGroupFoundException")
                                .exceptionBuilderSupplier(AssociatedEndpointGroupFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointGroupAlreadyExistsException")
                                .exceptionBuilderSupplier(EndpointGroupAlreadyExistsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPortRangeException")
                                .exceptionBuilderSupplier(InvalidPortRangeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointAlreadyExistsException")
                                .exceptionBuilderSupplier(EndpointAlreadyExistsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgumentException")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListenerNotFoundException")
                                .exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AcceleratorNotFoundException")
                                .exceptionBuilderSupplier(AcceleratorNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncorrectCidrStateException")
                                .exceptionBuilderSupplier(IncorrectCidrStateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TransactionInProgressException")
                                .exceptionBuilderSupplier(TransactionInProgressException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ByoipCidrNotFoundException")
                                .exceptionBuilderSupplier(ByoipCidrNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServiceErrorException")
                                .exceptionBuilderSupplier(InternalServiceErrorException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EndpointGroupNotFoundException")
                                .exceptionBuilderSupplier(EndpointGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AcceleratorNotDisabledException")
                                .exceptionBuilderSupplier(AcceleratorNotDisabledException::builder).httpStatusCode(400).build());
    }

    @Override
    public final GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
