/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.globalaccelerator.DefaultGlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.DefaultGlobalAcceleratorBaseClientBuilder;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClient;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorAsyncClientBuilder;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorServiceClientConfiguration;
import software.amazon.awssdk.services.globalaccelerator.endpoints.GlobalAcceleratorEndpointProvider;

@SdkInternalApi
final class DefaultGlobalAcceleratorAsyncClientBuilder
extends DefaultGlobalAcceleratorBaseClientBuilder<GlobalAcceleratorAsyncClientBuilder, GlobalAcceleratorAsyncClient>
implements GlobalAcceleratorAsyncClientBuilder {
    DefaultGlobalAcceleratorAsyncClientBuilder() {
    }

    @Override
    public DefaultGlobalAcceleratorAsyncClientBuilder endpointProvider(GlobalAcceleratorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GlobalAcceleratorAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGlobalAcceleratorAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGlobalAcceleratorAsyncClient client = new DefaultGlobalAcceleratorAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GlobalAcceleratorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GlobalAcceleratorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

