/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.model.Accelerator;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsRequest;
import software.amazon.awssdk.services.globalaccelerator.model.ListAcceleratorsResponse;

public class ListAcceleratorsIterable
implements SdkIterable<ListAcceleratorsResponse> {
    private final GlobalAcceleratorClient client;
    private final ListAcceleratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAcceleratorsIterable(GlobalAcceleratorClient client, ListAcceleratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAcceleratorsResponseFetcher();
    }

    public Iterator<ListAcceleratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Accelerator> accelerators() {
        Function<ListAcceleratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.accelerators() != null) {
                return response.accelerators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAcceleratorsResponseFetcher
    implements SyncPageFetcher<ListAcceleratorsResponse> {
        private ListAcceleratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceleratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAcceleratorsResponse nextPage(ListAcceleratorsResponse previousPage) {
            if (previousPage == null) {
                return ListAcceleratorsIterable.this.client.listAccelerators(ListAcceleratorsIterable.this.firstRequest);
            }
            return ListAcceleratorsIterable.this.client.listAccelerators((ListAcceleratorsRequest)((Object)ListAcceleratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

