/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomRoutingListenerRequest extends GlobalAcceleratorRequest implements
        ToCopyableBuilder<CreateCustomRoutingListenerRequest.Builder, CreateCustomRoutingListenerRequest> {
    private static final SdkField<String> ACCELERATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceleratorArn").getter(getter(CreateCustomRoutingListenerRequest::acceleratorArn))
            .setter(setter(Builder::acceleratorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorArn").build()).build();

    private static final SdkField<List<PortRange>> PORT_RANGES_FIELD = SdkField
            .<List<PortRange>> builder(MarshallingType.LIST)
            .memberName("PortRanges")
            .getter(getter(CreateCustomRoutingListenerRequest::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PortRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken")
            .getter(getter(CreateCustomRoutingListenerRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_ARN_FIELD,
            PORT_RANGES_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private final String acceleratorArn;

    private final List<PortRange> portRanges;

    private final String idempotencyToken;

    private CreateCustomRoutingListenerRequest(BuilderImpl builder) {
        super(builder);
        this.acceleratorArn = builder.acceleratorArn;
        this.portRanges = builder.portRanges;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.
     */
    public final String acceleratorArn() {
        return acceleratorArn;
    }

    /**
     * Returns true if the PortRanges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The port range to support for connections from clients to your accelerator.
     * </p>
     * <p>
     * Separately, you set port ranges for endpoints. For more information, see <a
     * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
     * endpoints for custom routing accelerators</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPortRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The port range to support for connections from clients to your accelerator.</p>
     *         <p>
     *         Separately, you set port ranges for endpoints. For more information, see <a
     *         href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
     *         endpoints for custom routing accelerators</a>.
     */
    public final List<PortRange> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
     * request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of
     *         the request.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomRoutingListenerRequest)) {
            return false;
        }
        CreateCustomRoutingListenerRequest other = (CreateCustomRoutingListenerRequest) obj;
        return Objects.equals(acceleratorArn(), other.acceleratorArn()) && hasPortRanges() == other.hasPortRanges()
                && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomRoutingListenerRequest").add("AcceleratorArn", acceleratorArn())
                .add("PortRanges", hasPortRanges() ? portRanges() : null).add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorArn":
            return Optional.ofNullable(clazz.cast(acceleratorArn()));
        case "PortRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomRoutingListenerRequest, T> g) {
        return obj -> g.apply((CreateCustomRoutingListenerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomRoutingListenerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.
         * </p>
         * 
         * @param acceleratorArn
         *        The Amazon Resource Name (ARN) of the accelerator for a custom routing listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorArn(String acceleratorArn);

        /**
         * <p>
         * The port range to support for connections from clients to your accelerator.
         * </p>
         * <p>
         * Separately, you set port ranges for endpoints. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators</a>.
         * </p>
         * 
         * @param portRanges
         *        The port range to support for connections from clients to your accelerator.</p>
         *        <p>
         *        Separately, you set port ranges for endpoints. For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html"
         *        >About endpoints for custom routing accelerators</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<PortRange> portRanges);

        /**
         * <p>
         * The port range to support for connections from clients to your accelerator.
         * </p>
         * <p>
         * Separately, you set port ranges for endpoints. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators</a>.
         * </p>
         * 
         * @param portRanges
         *        The port range to support for connections from clients to your accelerator.</p>
         *        <p>
         *        Separately, you set port ranges for endpoints. For more information, see <a
         *        href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html"
         *        >About endpoints for custom routing accelerators</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(PortRange... portRanges);

        /**
         * <p>
         * The port range to support for connections from clients to your accelerator.
         * </p>
         * <p>
         * Separately, you set port ranges for endpoints. For more information, see <a
         * href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PortRange>.Builder} avoiding the need to
         * create one manually via {@link List<PortRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PortRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #portRanges(List<PortRange>)}.
         * 
         * @param portRanges
         *        a consumer that will call methods on {@link List<PortRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portRanges(List<PortRange>)
         */
        Builder portRanges(Consumer<PortRange.Builder>... portRanges);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the uniqueness—of the
         * request.
         * </p>
         * 
         * @param idempotencyToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency—that is, the
         *        uniqueness—of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlobalAcceleratorRequest.BuilderImpl implements Builder {
        private String acceleratorArn;

        private List<PortRange> portRanges = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomRoutingListenerRequest model) {
            super(model);
            acceleratorArn(model.acceleratorArn);
            portRanges(model.portRanges);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getAcceleratorArn() {
            return acceleratorArn;
        }

        @Override
        public final Builder acceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
            return this;
        }

        public final void setAcceleratorArn(String acceleratorArn) {
            this.acceleratorArn = acceleratorArn;
        }

        public final Collection<PortRange.Builder> getPortRanges() {
            if (portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return portRanges != null ? portRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portRanges(Collection<PortRange> portRanges) {
            this.portRanges = PortRangesCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(PortRange... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(Consumer<PortRange.Builder>... portRanges) {
            portRanges(Stream.of(portRanges).map(c -> PortRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortRanges(Collection<PortRange.BuilderImpl> portRanges) {
            this.portRanges = PortRangesCopier.copyFromBuilder(portRanges);
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomRoutingListenerRequest build() {
            return new CreateCustomRoutingListenerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
