/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.globalaccelerator.model.IpAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpSet> {
    private static final SdkField<String> IP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpSet.getter(IpSet::ipFamily)).setter(IpSet.setter(Builder::ipFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpFamily").build()}).build();
    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(IpSet.getter(IpSet::ipAddresses)).setter(IpSet.setter(Builder::ipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FAMILY_FIELD, IP_ADDRESSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ipFamily;
    private final List<String> ipAddresses;

    private IpSet(BuilderImpl builder) {
        this.ipFamily = builder.ipFamily;
        this.ipAddresses = builder.ipAddresses;
    }

    public String ipFamily() {
        return this.ipFamily;
    }

    public boolean hasIpAddresses() {
        return this.ipAddresses != null && !(this.ipAddresses instanceof SdkAutoConstructList);
    }

    public List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpSet)) {
            return false;
        }
        IpSet other = (IpSet)obj;
        return Objects.equals(this.ipFamily(), other.ipFamily()) && Objects.equals(this.ipAddresses(), other.ipAddresses());
    }

    public String toString() {
        return ToString.builder((String)"IpSet").add("IpFamily", (Object)this.ipFamily()).add("IpAddresses", this.ipAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpFamily": {
                return Optional.ofNullable(clazz.cast(this.ipFamily()));
            }
            case "IpAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipAddresses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpSet, T> g) {
        return obj -> g.apply((IpSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ipFamily;
        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpSet model) {
            this.ipFamily(model.ipFamily);
            this.ipAddresses(model.ipAddresses);
        }

        public final String getIpFamily() {
            return this.ipFamily;
        }

        @Override
        public final Builder ipFamily(String ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        public final void setIpFamily(String ipFamily) {
            this.ipFamily = ipFamily;
        }

        public final Collection<String> getIpAddresses() {
            return this.ipAddresses;
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String ... ipAddresses) {
            this.ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = IpAddressesCopier.copy(ipAddresses);
        }

        public IpSet build() {
            return new IpSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpSet> {
        public Builder ipFamily(String var1);

        public Builder ipAddresses(Collection<String> var1);

        public Builder ipAddresses(String ... var1);
    }
}

