/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEndpointGroupResponse extends GlobalAcceleratorResponse implements
        ToCopyableBuilder<UpdateEndpointGroupResponse.Builder, UpdateEndpointGroupResponse> {
    private static final SdkField<EndpointGroup> ENDPOINT_GROUP_FIELD = SdkField
            .<EndpointGroup> builder(MarshallingType.SDK_POJO).getter(getter(UpdateEndpointGroupResponse::endpointGroup))
            .setter(setter(Builder::endpointGroup)).constructor(EndpointGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_FIELD));

    private final EndpointGroup endpointGroup;

    private UpdateEndpointGroupResponse(BuilderImpl builder) {
        super(builder);
        this.endpointGroup = builder.endpointGroup;
    }

    /**
     * <p>
     * The information about the endpoint group that was updated.
     * </p>
     * 
     * @return The information about the endpoint group that was updated.
     */
    public EndpointGroup endpointGroup() {
        return endpointGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointGroupResponse)) {
            return false;
        }
        UpdateEndpointGroupResponse other = (UpdateEndpointGroupResponse) obj;
        return Objects.equals(endpointGroup(), other.endpointGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEndpointGroupResponse").add("EndpointGroup", endpointGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroup":
            return Optional.ofNullable(clazz.cast(endpointGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEndpointGroupResponse, T> g) {
        return obj -> g.apply((UpdateEndpointGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlobalAcceleratorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateEndpointGroupResponse> {
        /**
         * <p>
         * The information about the endpoint group that was updated.
         * </p>
         * 
         * @param endpointGroup
         *        The information about the endpoint group that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroup(EndpointGroup endpointGroup);

        /**
         * <p>
         * The information about the endpoint group that was updated.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointGroup.Builder} avoiding the need to
         * create one manually via {@link EndpointGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointGroup(EndpointGroup)}.
         * 
         * @param endpointGroup
         *        a consumer that will call methods on {@link EndpointGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointGroup(EndpointGroup)
         */
        default Builder endpointGroup(Consumer<EndpointGroup.Builder> endpointGroup) {
            return endpointGroup(EndpointGroup.builder().applyMutation(endpointGroup).build());
        }
    }

    static final class BuilderImpl extends GlobalAcceleratorResponse.BuilderImpl implements Builder {
        private EndpointGroup endpointGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointGroupResponse model) {
            super(model);
            endpointGroup(model.endpointGroup);
        }

        public final EndpointGroup.Builder getEndpointGroup() {
            return endpointGroup != null ? endpointGroup.toBuilder() : null;
        }

        @Override
        public final Builder endpointGroup(EndpointGroup endpointGroup) {
            this.endpointGroup = endpointGroup;
            return this;
        }

        public final void setEndpointGroup(EndpointGroup.BuilderImpl endpointGroup) {
            this.endpointGroup = endpointGroup != null ? endpointGroup.build() : null;
        }

        @Override
        public UpdateEndpointGroupResponse build() {
            return new UpdateEndpointGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
