/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gameliftstreams.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.gameliftstreams.GameLiftStreamsAsyncClient;
import software.amazon.awssdk.services.gameliftstreams.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.gameliftstreams.model.GameLiftStreamsRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetApplicationRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetApplicationResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamGroupResponse;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionRequest;
import software.amazon.awssdk.services.gameliftstreams.model.GetStreamSessionResponse;
import software.amazon.awssdk.services.gameliftstreams.waiters.GameLiftStreamsAsyncWaiter;
import software.amazon.awssdk.services.gameliftstreams.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultGameLiftStreamsAsyncWaiter
implements GameLiftStreamsAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final GameLiftStreamsAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetApplicationResponse> applicationDeletedWaiter;
    private final AsyncWaiter<GetApplicationResponse> applicationReadyWaiter;
    private final AsyncWaiter<GetStreamGroupResponse> streamGroupActiveWaiter;
    private final AsyncWaiter<GetStreamGroupResponse> streamGroupDeletedWaiter;
    private final AsyncWaiter<GetStreamSessionResponse> streamSessionActiveWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultGameLiftStreamsAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (GameLiftStreamsAsyncClient)GameLiftStreamsAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.applicationDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetApplicationResponse.class).acceptors(DefaultGameLiftStreamsAsyncWaiter.applicationDeletedWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsAsyncWaiter.applicationDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.applicationReadyWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetApplicationResponse.class).acceptors(DefaultGameLiftStreamsAsyncWaiter.applicationReadyWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsAsyncWaiter.applicationReadyWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamGroupActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamGroupResponse.class).acceptors(DefaultGameLiftStreamsAsyncWaiter.streamGroupActiveWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsAsyncWaiter.streamGroupActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamGroupDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamGroupResponse.class).acceptors(DefaultGameLiftStreamsAsyncWaiter.streamGroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsAsyncWaiter.streamGroupDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.streamSessionActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetStreamSessionResponse.class).acceptors(DefaultGameLiftStreamsAsyncWaiter.streamSessionActiveWaiterAcceptors())).overrideConfiguration(DefaultGameLiftStreamsAsyncWaiter.streamSessionActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetApplicationResponse>> waitUntilApplicationDeleted(GetApplicationRequest getApplicationRequest) {
        return this.applicationDeletedWaiter.runAsync(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetApplicationResponse>> waitUntilApplicationDeleted(GetApplicationRequest getApplicationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.applicationDeletedWaiter.runAsync(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)), DefaultGameLiftStreamsAsyncWaiter.applicationDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetApplicationResponse>> waitUntilApplicationReady(GetApplicationRequest getApplicationRequest) {
        return this.applicationReadyWaiter.runAsync(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetApplicationResponse>> waitUntilApplicationReady(GetApplicationRequest getApplicationRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.applicationReadyWaiter.runAsync(() -> this.client.getApplication(this.applyWaitersUserAgent(getApplicationRequest)), DefaultGameLiftStreamsAsyncWaiter.applicationReadyWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamGroupResponse>> waitUntilStreamGroupActive(GetStreamGroupRequest getStreamGroupRequest) {
        return this.streamGroupActiveWaiter.runAsync(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamGroupResponse>> waitUntilStreamGroupActive(GetStreamGroupRequest getStreamGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamGroupActiveWaiter.runAsync(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)), DefaultGameLiftStreamsAsyncWaiter.streamGroupActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamGroupResponse>> waitUntilStreamGroupDeleted(GetStreamGroupRequest getStreamGroupRequest) {
        return this.streamGroupDeletedWaiter.runAsync(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamGroupResponse>> waitUntilStreamGroupDeleted(GetStreamGroupRequest getStreamGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamGroupDeletedWaiter.runAsync(() -> this.client.getStreamGroup(this.applyWaitersUserAgent(getStreamGroupRequest)), DefaultGameLiftStreamsAsyncWaiter.streamGroupDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamSessionResponse>> waitUntilStreamSessionActive(GetStreamSessionRequest getStreamSessionRequest) {
        return this.streamSessionActiveWaiter.runAsync(() -> this.client.getStreamSession(this.applyWaitersUserAgent(getStreamSessionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetStreamSessionResponse>> waitUntilStreamSessionActive(GetStreamSessionRequest getStreamSessionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.streamSessionActiveWaiter.runAsync(() -> this.client.getStreamSession(this.applyWaitersUserAgent(getStreamSessionRequest)), DefaultGameLiftStreamsAsyncWaiter.streamSessionActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetApplicationResponse>> applicationDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetApplicationResponse>> result = new ArrayList<WaiterAcceptor<? super GetApplicationResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultGameLiftStreamsAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetApplicationResponse>> applicationReadyWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetApplicationResponse>> result = new ArrayList<WaiterAcceptor<? super GetApplicationResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "READY");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamGroupResponse>> streamGroupActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ERROR) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ACTIVE_WITH_ERRORS");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ACTIVE_WITH_ERRORS) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "DELETING");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=DELETING) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamGroupResponse>> streamGroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamGroupResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultGameLiftStreamsAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetStreamSessionResponse>> streamSessionActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetStreamSessionResponse>> result = new ArrayList<WaiterAcceptor<? super GetStreamSessionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "ERROR");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=ERROR) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration applicationDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration applicationReadyWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamGroupActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamGroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration streamSessionActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(2L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static GameLiftStreamsAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends GameLiftStreamsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((GameLiftStreamsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements GameLiftStreamsAsyncWaiter.Builder {
        private GameLiftStreamsAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public GameLiftStreamsAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public GameLiftStreamsAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public GameLiftStreamsAsyncWaiter.Builder client(GameLiftStreamsAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public GameLiftStreamsAsyncWaiter build() {
            return new DefaultGameLiftStreamsAsyncWaiter(this);
        }
    }
}

