/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.Player;
import software.amazon.awssdk.services.gamelift.model.PlayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMatchBackfillRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, StartMatchBackfillRequest> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartMatchBackfillRequest.getter(StartMatchBackfillRequest::ticketId)).setter(StartMatchBackfillRequest.setter(Builder::ticketId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()}).build();
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartMatchBackfillRequest.getter(StartMatchBackfillRequest::configurationName)).setter(StartMatchBackfillRequest.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()}).build();
    private static final SdkField<String> GAME_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartMatchBackfillRequest.getter(StartMatchBackfillRequest::gameSessionArn)).setter(StartMatchBackfillRequest.setter(Builder::gameSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionArn").build()}).build();
    private static final SdkField<List<Player>> PLAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartMatchBackfillRequest.getter(StartMatchBackfillRequest::players)).setter(StartMatchBackfillRequest.setter(Builder::players)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Players").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Player::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD, CONFIGURATION_NAME_FIELD, GAME_SESSION_ARN_FIELD, PLAYERS_FIELD));
    private final String ticketId;
    private final String configurationName;
    private final String gameSessionArn;
    private final List<Player> players;

    private StartMatchBackfillRequest(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.configurationName = builder.configurationName;
        this.gameSessionArn = builder.gameSessionArn;
        this.players = builder.players;
    }

    public String ticketId() {
        return this.ticketId;
    }

    public String configurationName() {
        return this.configurationName;
    }

    public String gameSessionArn() {
        return this.gameSessionArn;
    }

    public List<Player> players() {
        return this.players;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.players());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMatchBackfillRequest)) {
            return false;
        }
        StartMatchBackfillRequest other = (StartMatchBackfillRequest)((Object)obj);
        return Objects.equals(this.ticketId(), other.ticketId()) && Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.gameSessionArn(), other.gameSessionArn()) && Objects.equals(this.players(), other.players());
    }

    public String toString() {
        return ToString.builder((String)"StartMatchBackfillRequest").add("TicketId", (Object)this.ticketId()).add("ConfigurationName", (Object)this.configurationName()).add("GameSessionArn", (Object)this.gameSessionArn()).add("Players", this.players()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketId": {
                return Optional.ofNullable(clazz.cast(this.ticketId()));
            }
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "GameSessionArn": {
                return Optional.ofNullable(clazz.cast(this.gameSessionArn()));
            }
            case "Players": {
                return Optional.ofNullable(clazz.cast(this.players()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMatchBackfillRequest, T> g) {
        return obj -> g.apply((StartMatchBackfillRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String ticketId;
        private String configurationName;
        private String gameSessionArn;
        private List<Player> players = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMatchBackfillRequest model) {
            super(model);
            this.ticketId(model.ticketId);
            this.configurationName(model.configurationName);
            this.gameSessionArn(model.gameSessionArn);
            this.players(model.players);
        }

        public final String getTicketId() {
            return this.ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        public final String getGameSessionArn() {
            return this.gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        public final Collection<Player.Builder> getPlayers() {
            return this.players != null ? (Collection)this.players.stream().map(Player::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder players(Collection<Player> players) {
            this.players = PlayerListCopier.copy(players);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Player ... players) {
            this.players(Arrays.asList(players));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Consumer<Player.Builder> ... players) {
            this.players(Stream.of(players).map(c -> (Player)((Player.Builder)Player.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlayers(Collection<Player.BuilderImpl> players) {
            this.players = PlayerListCopier.copyFromBuilder(players);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMatchBackfillRequest build() {
            return new StartMatchBackfillRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMatchBackfillRequest> {
        public Builder ticketId(String var1);

        public Builder configurationName(String var1);

        public Builder gameSessionArn(String var1);

        public Builder players(Collection<Player> var1);

        public Builder players(Player ... var1);

        public Builder players(Consumer<Player.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

