/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2InstanceLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2InstanceLimit> {
    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EC2InstanceLimit.getter(EC2InstanceLimit::ec2InstanceTypeAsString)).setter(EC2InstanceLimit.setter(Builder::ec2InstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()}).build();
    private static final SdkField<Integer> CURRENT_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EC2InstanceLimit.getter(EC2InstanceLimit::currentInstances)).setter(EC2InstanceLimit.setter(Builder::currentInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstances").build()}).build();
    private static final SdkField<Integer> INSTANCE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(EC2InstanceLimit.getter(EC2InstanceLimit::instanceLimit)).setter(EC2InstanceLimit.setter(Builder::instanceLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_TYPE_FIELD, CURRENT_INSTANCES_FIELD, INSTANCE_LIMIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ec2InstanceType;
    private final Integer currentInstances;
    private final Integer instanceLimit;

    private EC2InstanceLimit(BuilderImpl builder) {
        this.ec2InstanceType = builder.ec2InstanceType;
        this.currentInstances = builder.currentInstances;
        this.instanceLimit = builder.instanceLimit;
    }

    public EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public String ec2InstanceTypeAsString() {
        return this.ec2InstanceType;
    }

    public Integer currentInstances() {
        return this.currentInstances;
    }

    public Integer instanceLimit() {
        return this.instanceLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceLimit)) {
            return false;
        }
        EC2InstanceLimit other = (EC2InstanceLimit)obj;
        return Objects.equals(this.ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString()) && Objects.equals(this.currentInstances(), other.currentInstances()) && Objects.equals(this.instanceLimit(), other.instanceLimit());
    }

    public String toString() {
        return ToString.builder((String)"EC2InstanceLimit").add("EC2InstanceType", (Object)this.ec2InstanceTypeAsString()).add("CurrentInstances", (Object)this.currentInstances()).add("InstanceLimit", (Object)this.instanceLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceType": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTypeAsString()));
            }
            case "CurrentInstances": {
                return Optional.ofNullable(clazz.cast(this.currentInstances()));
            }
            case "InstanceLimit": {
                return Optional.ofNullable(clazz.cast(this.instanceLimit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceLimit, T> g) {
        return obj -> g.apply((EC2InstanceLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2InstanceType;
        private Integer currentInstances;
        private Integer instanceLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceLimit model) {
            this.ec2InstanceType(model.ec2InstanceType);
            this.currentInstances(model.currentInstances);
            this.instanceLimit(model.instanceLimit);
        }

        public final String getEc2InstanceTypeAsString() {
            return this.ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType.toString());
            return this;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        public final Integer getCurrentInstances() {
            return this.currentInstances;
        }

        @Override
        public final Builder currentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
            return this;
        }

        public final void setCurrentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
        }

        public final Integer getInstanceLimit() {
            return this.instanceLimit;
        }

        @Override
        public final Builder instanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
            return this;
        }

        public final void setInstanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
        }

        public EC2InstanceLimit build() {
            return new EC2InstanceLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2InstanceLimit> {
        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder currentInstances(Integer var1);

        public Builder instanceLimit(Integer var1);
    }
}

