/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.Build;
import software.amazon.awssdk.services.gamelift.model.BuildListCopier;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBuildsResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, ListBuildsResponse> {
    private static final SdkField<List<Build>> BUILDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListBuildsResponse.getter(ListBuildsResponse::builds)).setter(ListBuildsResponse.setter(Builder::builds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Builds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Build::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListBuildsResponse.getter(ListBuildsResponse::nextToken)).setter(ListBuildsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Build> builds;
    private final String nextToken;

    private ListBuildsResponse(BuilderImpl builder) {
        super(builder);
        this.builds = builder.builds;
        this.nextToken = builder.nextToken;
    }

    public List<Build> builds() {
        return this.builds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.builds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsResponse)) {
            return false;
        }
        ListBuildsResponse other = (ListBuildsResponse)((Object)obj);
        return Objects.equals(this.builds(), other.builds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListBuildsResponse").add("Builds", this.builds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Builds": {
                return Optional.ofNullable(clazz.cast(this.builds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuildsResponse, T> g) {
        return obj -> g.apply((ListBuildsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private List<Build> builds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsResponse model) {
            super(model);
            this.builds(model.builds);
            this.nextToken(model.nextToken);
        }

        public final Collection<Build.Builder> getBuilds() {
            return this.builds != null ? (Collection)this.builds.stream().map(Build::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder builds(Collection<Build> builds) {
            this.builds = BuildListCopier.copy(builds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Build ... builds) {
            this.builds(Arrays.asList(builds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder builds(Consumer<Build.Builder> ... builds) {
            this.builds(Stream.of(builds).map(c -> (Build)((Build.Builder)Build.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBuilds(Collection<Build.BuilderImpl> builds) {
            this.builds = BuildListCopier.copyFromBuilder(builds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBuildsResponse build() {
            return new ListBuildsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBuildsResponse> {
        public Builder builds(Collection<Build> var1);

        public Builder builds(Build ... var1);

        public Builder builds(Consumer<Build.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

