/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.BackfillMode;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.services.gamelift.model.QueueArnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchmakingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchmakingConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::name)).setter(MatchmakingConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::description)).setter(MatchmakingConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> GAME_SESSION_QUEUE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::gameSessionQueueArns)).setter(MatchmakingConfiguration.setter(Builder::gameSessionQueueArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> REQUEST_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::requestTimeoutSeconds)).setter(MatchmakingConfiguration.setter(Builder::requestTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> ACCEPTANCE_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::acceptanceTimeoutSeconds)).setter(MatchmakingConfiguration.setter(Builder::acceptanceTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceTimeoutSeconds").build()}).build();
    private static final SdkField<Boolean> ACCEPTANCE_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::acceptanceRequired)).setter(MatchmakingConfiguration.setter(Builder::acceptanceRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptanceRequired").build()}).build();
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::ruleSetName)).setter(MatchmakingConfiguration.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<String> NOTIFICATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::notificationTarget)).setter(MatchmakingConfiguration.setter(Builder::notificationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTarget").build()}).build();
    private static final SdkField<Integer> ADDITIONAL_PLAYER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::additionalPlayerCount)).setter(MatchmakingConfiguration.setter(Builder::additionalPlayerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalPlayerCount").build()}).build();
    private static final SdkField<String> CUSTOM_EVENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::customEventData)).setter(MatchmakingConfiguration.setter(Builder::customEventData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEventData").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::creationTime)).setter(MatchmakingConfiguration.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::gameProperties)).setter(MatchmakingConfiguration.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::gameSessionData)).setter(MatchmakingConfiguration.setter(Builder::gameSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()}).build();
    private static final SdkField<String> BACKFILL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MatchmakingConfiguration.getter(MatchmakingConfiguration::backfillModeAsString)).setter(MatchmakingConfiguration.setter(Builder::backfillMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackfillMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, GAME_SESSION_QUEUE_ARNS_FIELD, REQUEST_TIMEOUT_SECONDS_FIELD, ACCEPTANCE_TIMEOUT_SECONDS_FIELD, ACCEPTANCE_REQUIRED_FIELD, RULE_SET_NAME_FIELD, NOTIFICATION_TARGET_FIELD, ADDITIONAL_PLAYER_COUNT_FIELD, CUSTOM_EVENT_DATA_FIELD, CREATION_TIME_FIELD, GAME_PROPERTIES_FIELD, GAME_SESSION_DATA_FIELD, BACKFILL_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final List<String> gameSessionQueueArns;
    private final Integer requestTimeoutSeconds;
    private final Integer acceptanceTimeoutSeconds;
    private final Boolean acceptanceRequired;
    private final String ruleSetName;
    private final String notificationTarget;
    private final Integer additionalPlayerCount;
    private final String customEventData;
    private final Instant creationTime;
    private final List<GameProperty> gameProperties;
    private final String gameSessionData;
    private final String backfillMode;

    private MatchmakingConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.gameSessionQueueArns = builder.gameSessionQueueArns;
        this.requestTimeoutSeconds = builder.requestTimeoutSeconds;
        this.acceptanceTimeoutSeconds = builder.acceptanceTimeoutSeconds;
        this.acceptanceRequired = builder.acceptanceRequired;
        this.ruleSetName = builder.ruleSetName;
        this.notificationTarget = builder.notificationTarget;
        this.additionalPlayerCount = builder.additionalPlayerCount;
        this.customEventData = builder.customEventData;
        this.creationTime = builder.creationTime;
        this.gameProperties = builder.gameProperties;
        this.gameSessionData = builder.gameSessionData;
        this.backfillMode = builder.backfillMode;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<String> gameSessionQueueArns() {
        return this.gameSessionQueueArns;
    }

    public Integer requestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    public Integer acceptanceTimeoutSeconds() {
        return this.acceptanceTimeoutSeconds;
    }

    public Boolean acceptanceRequired() {
        return this.acceptanceRequired;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String notificationTarget() {
        return this.notificationTarget;
    }

    public Integer additionalPlayerCount() {
        return this.additionalPlayerCount;
    }

    public String customEventData() {
        return this.customEventData;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public String gameSessionData() {
        return this.gameSessionData;
    }

    public BackfillMode backfillMode() {
        return BackfillMode.fromValue(this.backfillMode);
    }

    public String backfillModeAsString() {
        return this.backfillMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalPlayerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.backfillModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchmakingConfiguration)) {
            return false;
        }
        MatchmakingConfiguration other = (MatchmakingConfiguration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.gameSessionQueueArns(), other.gameSessionQueueArns()) && Objects.equals(this.requestTimeoutSeconds(), other.requestTimeoutSeconds()) && Objects.equals(this.acceptanceTimeoutSeconds(), other.acceptanceTimeoutSeconds()) && Objects.equals(this.acceptanceRequired(), other.acceptanceRequired()) && Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.notificationTarget(), other.notificationTarget()) && Objects.equals(this.additionalPlayerCount(), other.additionalPlayerCount()) && Objects.equals(this.customEventData(), other.customEventData()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.gameSessionData(), other.gameSessionData()) && Objects.equals(this.backfillModeAsString(), other.backfillModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"MatchmakingConfiguration").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("GameSessionQueueArns", this.gameSessionQueueArns()).add("RequestTimeoutSeconds", (Object)this.requestTimeoutSeconds()).add("AcceptanceTimeoutSeconds", (Object)this.acceptanceTimeoutSeconds()).add("AcceptanceRequired", (Object)this.acceptanceRequired()).add("RuleSetName", (Object)this.ruleSetName()).add("NotificationTarget", (Object)this.notificationTarget()).add("AdditionalPlayerCount", (Object)this.additionalPlayerCount()).add("CustomEventData", (Object)this.customEventData()).add("CreationTime", (Object)this.creationTime()).add("GameProperties", this.gameProperties()).add("GameSessionData", (Object)this.gameSessionData()).add("BackfillMode", (Object)this.backfillModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GameSessionQueueArns": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueueArns()));
            }
            case "RequestTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.requestTimeoutSeconds()));
            }
            case "AcceptanceTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.acceptanceTimeoutSeconds()));
            }
            case "AcceptanceRequired": {
                return Optional.ofNullable(clazz.cast(this.acceptanceRequired()));
            }
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "NotificationTarget": {
                return Optional.ofNullable(clazz.cast(this.notificationTarget()));
            }
            case "AdditionalPlayerCount": {
                return Optional.ofNullable(clazz.cast(this.additionalPlayerCount()));
            }
            case "CustomEventData": {
                return Optional.ofNullable(clazz.cast(this.customEventData()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
            case "GameSessionData": {
                return Optional.ofNullable(clazz.cast(this.gameSessionData()));
            }
            case "BackfillMode": {
                return Optional.ofNullable(clazz.cast(this.backfillModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchmakingConfiguration, T> g) {
        return obj -> g.apply((MatchmakingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> gameSessionQueueArns = DefaultSdkAutoConstructList.getInstance();
        private Integer requestTimeoutSeconds;
        private Integer acceptanceTimeoutSeconds;
        private Boolean acceptanceRequired;
        private String ruleSetName;
        private String notificationTarget;
        private Integer additionalPlayerCount;
        private String customEventData;
        private Instant creationTime;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();
        private String gameSessionData;
        private String backfillMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchmakingConfiguration model) {
            this.name(model.name);
            this.description(model.description);
            this.gameSessionQueueArns(model.gameSessionQueueArns);
            this.requestTimeoutSeconds(model.requestTimeoutSeconds);
            this.acceptanceTimeoutSeconds(model.acceptanceTimeoutSeconds);
            this.acceptanceRequired(model.acceptanceRequired);
            this.ruleSetName(model.ruleSetName);
            this.notificationTarget(model.notificationTarget);
            this.additionalPlayerCount(model.additionalPlayerCount);
            this.customEventData(model.customEventData);
            this.creationTime(model.creationTime);
            this.gameProperties(model.gameProperties);
            this.gameSessionData(model.gameSessionData);
            this.backfillMode(model.backfillMode);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getGameSessionQueueArns() {
            return this.gameSessionQueueArns;
        }

        @Override
        public final Builder gameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameSessionQueueArns(String ... gameSessionQueueArns) {
            this.gameSessionQueueArns(Arrays.asList(gameSessionQueueArns));
            return this;
        }

        public final void setGameSessionQueueArns(Collection<String> gameSessionQueueArns) {
            this.gameSessionQueueArns = QueueArnsListCopier.copy(gameSessionQueueArns);
        }

        public final Integer getRequestTimeoutSeconds() {
            return this.requestTimeoutSeconds;
        }

        @Override
        public final Builder requestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
            return this;
        }

        public final void setRequestTimeoutSeconds(Integer requestTimeoutSeconds) {
            this.requestTimeoutSeconds = requestTimeoutSeconds;
        }

        public final Integer getAcceptanceTimeoutSeconds() {
            return this.acceptanceTimeoutSeconds;
        }

        @Override
        public final Builder acceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
            return this;
        }

        public final void setAcceptanceTimeoutSeconds(Integer acceptanceTimeoutSeconds) {
            this.acceptanceTimeoutSeconds = acceptanceTimeoutSeconds;
        }

        public final Boolean getAcceptanceRequired() {
            return this.acceptanceRequired;
        }

        @Override
        public final Builder acceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
            return this;
        }

        public final void setAcceptanceRequired(Boolean acceptanceRequired) {
            this.acceptanceRequired = acceptanceRequired;
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public final Builder notificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        public final void setNotificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
        }

        public final Integer getAdditionalPlayerCount() {
            return this.additionalPlayerCount;
        }

        @Override
        public final Builder additionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
            return this;
        }

        public final void setAdditionalPlayerCount(Integer additionalPlayerCount) {
            this.additionalPlayerCount = additionalPlayerCount;
        }

        public final String getCustomEventData() {
            return this.customEventData;
        }

        @Override
        public final Builder customEventData(String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        public final void setCustomEventData(String customEventData) {
            this.customEventData = customEventData;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<GameProperty.Builder> getGameProperties() {
            return this.gameProperties != null ? (Collection)this.gameProperties.stream().map(GameProperty::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        public final String getBackfillModeAsString() {
            return this.backfillMode;
        }

        @Override
        public final Builder backfillMode(String backfillMode) {
            this.backfillMode = backfillMode;
            return this;
        }

        @Override
        public final Builder backfillMode(BackfillMode backfillMode) {
            this.backfillMode(backfillMode.toString());
            return this;
        }

        public final void setBackfillMode(String backfillMode) {
            this.backfillMode = backfillMode;
        }

        public MatchmakingConfiguration build() {
            return new MatchmakingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchmakingConfiguration> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder gameSessionQueueArns(Collection<String> var1);

        public Builder gameSessionQueueArns(String ... var1);

        public Builder requestTimeoutSeconds(Integer var1);

        public Builder acceptanceTimeoutSeconds(Integer var1);

        public Builder acceptanceRequired(Boolean var1);

        public Builder ruleSetName(String var1);

        public Builder notificationTarget(String var1);

        public Builder additionalPlayerCount(Integer var1);

        public Builder customEventData(String var1);

        public Builder creationTime(Instant var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder gameSessionData(String var1);

        public Builder backfillMode(String var1);

        public Builder backfillMode(BackfillMode var1);
    }
}

