/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.RoutingStrategyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAliasesRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, ListAliasesRequest> {
    private static final SdkField<String> ROUTING_STRATEGY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAliasesRequest.getter(ListAliasesRequest::routingStrategyTypeAsString)).setter(ListAliasesRequest.setter(Builder::routingStrategyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingStrategyType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAliasesRequest.getter(ListAliasesRequest::name)).setter(ListAliasesRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListAliasesRequest.getter(ListAliasesRequest::limit)).setter(ListAliasesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAliasesRequest.getter(ListAliasesRequest::nextToken)).setter(ListAliasesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTING_STRATEGY_TYPE_FIELD, NAME_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String routingStrategyType;
    private final String name;
    private final Integer limit;
    private final String nextToken;

    private ListAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.routingStrategyType = builder.routingStrategyType;
        this.name = builder.name;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public RoutingStrategyType routingStrategyType() {
        return RoutingStrategyType.fromValue(this.routingStrategyType);
    }

    public String routingStrategyTypeAsString() {
        return this.routingStrategyType;
    }

    public String name() {
        return this.name;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routingStrategyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesRequest)) {
            return false;
        }
        ListAliasesRequest other = (ListAliasesRequest)((Object)obj);
        return Objects.equals(this.routingStrategyTypeAsString(), other.routingStrategyTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAliasesRequest").add("RoutingStrategyType", (Object)this.routingStrategyTypeAsString()).add("Name", (Object)this.name()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RoutingStrategyType": {
                return Optional.ofNullable(clazz.cast(this.routingStrategyTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAliasesRequest, T> g) {
        return obj -> g.apply((ListAliasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String routingStrategyType;
        private String name;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesRequest model) {
            super(model);
            this.routingStrategyType(model.routingStrategyType);
            this.name(model.name);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getRoutingStrategyTypeAsString() {
            return this.routingStrategyType;
        }

        @Override
        public final Builder routingStrategyType(String routingStrategyType) {
            this.routingStrategyType = routingStrategyType;
            return this;
        }

        @Override
        public final Builder routingStrategyType(RoutingStrategyType routingStrategyType) {
            this.routingStrategyType(routingStrategyType.toString());
            return this;
        }

        public final void setRoutingStrategyType(String routingStrategyType) {
            this.routingStrategyType = routingStrategyType;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAliasesRequest build() {
            return new ListAliasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAliasesRequest> {
        public Builder routingStrategyType(String var1);

        public Builder routingStrategyType(RoutingStrategyType var1);

        public Builder name(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

