/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlayerLatencyPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlayerLatencyPolicy> {
    private static final SdkField<Integer> MAXIMUM_INDIVIDUAL_PLAYER_LATENCY_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PlayerLatencyPolicy.getter(PlayerLatencyPolicy::maximumIndividualPlayerLatencyMilliseconds)).setter(PlayerLatencyPolicy.setter(Builder::maximumIndividualPlayerLatencyMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumIndividualPlayerLatencyMilliseconds").build()}).build();
    private static final SdkField<Integer> POLICY_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(PlayerLatencyPolicy.getter(PlayerLatencyPolicy::policyDurationSeconds)).setter(PlayerLatencyPolicy.setter(Builder::policyDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDurationSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAXIMUM_INDIVIDUAL_PLAYER_LATENCY_MILLISECONDS_FIELD, POLICY_DURATION_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maximumIndividualPlayerLatencyMilliseconds;
    private final Integer policyDurationSeconds;

    private PlayerLatencyPolicy(BuilderImpl builder) {
        this.maximumIndividualPlayerLatencyMilliseconds = builder.maximumIndividualPlayerLatencyMilliseconds;
        this.policyDurationSeconds = builder.policyDurationSeconds;
    }

    public Integer maximumIndividualPlayerLatencyMilliseconds() {
        return this.maximumIndividualPlayerLatencyMilliseconds;
    }

    public Integer policyDurationSeconds() {
        return this.policyDurationSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumIndividualPlayerLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDurationSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatencyPolicy)) {
            return false;
        }
        PlayerLatencyPolicy other = (PlayerLatencyPolicy)obj;
        return Objects.equals(this.maximumIndividualPlayerLatencyMilliseconds(), other.maximumIndividualPlayerLatencyMilliseconds()) && Objects.equals(this.policyDurationSeconds(), other.policyDurationSeconds());
    }

    public String toString() {
        return ToString.builder((String)"PlayerLatencyPolicy").add("MaximumIndividualPlayerLatencyMilliseconds", (Object)this.maximumIndividualPlayerLatencyMilliseconds()).add("PolicyDurationSeconds", (Object)this.policyDurationSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaximumIndividualPlayerLatencyMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.maximumIndividualPlayerLatencyMilliseconds()));
            }
            case "PolicyDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.policyDurationSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlayerLatencyPolicy, T> g) {
        return obj -> g.apply((PlayerLatencyPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maximumIndividualPlayerLatencyMilliseconds;
        private Integer policyDurationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatencyPolicy model) {
            this.maximumIndividualPlayerLatencyMilliseconds(model.maximumIndividualPlayerLatencyMilliseconds);
            this.policyDurationSeconds(model.policyDurationSeconds);
        }

        public final Integer getMaximumIndividualPlayerLatencyMilliseconds() {
            return this.maximumIndividualPlayerLatencyMilliseconds;
        }

        @Override
        public final Builder maximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds) {
            this.maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds;
            return this;
        }

        public final void setMaximumIndividualPlayerLatencyMilliseconds(Integer maximumIndividualPlayerLatencyMilliseconds) {
            this.maximumIndividualPlayerLatencyMilliseconds = maximumIndividualPlayerLatencyMilliseconds;
        }

        public final Integer getPolicyDurationSeconds() {
            return this.policyDurationSeconds;
        }

        @Override
        public final Builder policyDurationSeconds(Integer policyDurationSeconds) {
            this.policyDurationSeconds = policyDurationSeconds;
            return this;
        }

        public final void setPolicyDurationSeconds(Integer policyDurationSeconds) {
            this.policyDurationSeconds = policyDurationSeconds;
        }

        public PlayerLatencyPolicy build() {
            return new PlayerLatencyPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlayerLatencyPolicy> {
        public Builder maximumIndividualPlayerLatencyMilliseconds(Integer var1);

        public Builder policyDurationSeconds(Integer var1);
    }
}

