/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlayerLatency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlayerLatency> {
    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlayerLatency.getter(PlayerLatency::playerId)).setter(PlayerLatency.setter(Builder::playerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()}).build();
    private static final SdkField<String> REGION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PlayerLatency.getter(PlayerLatency::regionIdentifier)).setter(PlayerLatency.setter(Builder::regionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionIdentifier").build()}).build();
    private static final SdkField<Float> LATENCY_IN_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(PlayerLatency.getter(PlayerLatency::latencyInMilliseconds)).setter(PlayerLatency.setter(Builder::latencyInMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatencyInMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAYER_ID_FIELD, REGION_IDENTIFIER_FIELD, LATENCY_IN_MILLISECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String playerId;
    private final String regionIdentifier;
    private final Float latencyInMilliseconds;

    private PlayerLatency(BuilderImpl builder) {
        this.playerId = builder.playerId;
        this.regionIdentifier = builder.regionIdentifier;
        this.latencyInMilliseconds = builder.latencyInMilliseconds;
    }

    public String playerId() {
        return this.playerId;
    }

    public String regionIdentifier() {
        return this.regionIdentifier;
    }

    public Float latencyInMilliseconds() {
        return this.latencyInMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.playerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyInMilliseconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlayerLatency)) {
            return false;
        }
        PlayerLatency other = (PlayerLatency)obj;
        return Objects.equals(this.playerId(), other.playerId()) && Objects.equals(this.regionIdentifier(), other.regionIdentifier()) && Objects.equals(this.latencyInMilliseconds(), other.latencyInMilliseconds());
    }

    public String toString() {
        return ToString.builder((String)"PlayerLatency").add("PlayerId", (Object)this.playerId()).add("RegionIdentifier", (Object)this.regionIdentifier()).add("LatencyInMilliseconds", (Object)this.latencyInMilliseconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlayerId": {
                return Optional.ofNullable(clazz.cast(this.playerId()));
            }
            case "RegionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.regionIdentifier()));
            }
            case "LatencyInMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.latencyInMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlayerLatency, T> g) {
        return obj -> g.apply((PlayerLatency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String playerId;
        private String regionIdentifier;
        private Float latencyInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PlayerLatency model) {
            this.playerId(model.playerId);
            this.regionIdentifier(model.regionIdentifier);
            this.latencyInMilliseconds(model.latencyInMilliseconds);
        }

        public final String getPlayerId() {
            return this.playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        public final String getRegionIdentifier() {
            return this.regionIdentifier;
        }

        @Override
        public final Builder regionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
            return this;
        }

        public final void setRegionIdentifier(String regionIdentifier) {
            this.regionIdentifier = regionIdentifier;
        }

        public final Float getLatencyInMilliseconds() {
            return this.latencyInMilliseconds;
        }

        @Override
        public final Builder latencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
            return this;
        }

        public final void setLatencyInMilliseconds(Float latencyInMilliseconds) {
            this.latencyInMilliseconds = latencyInMilliseconds;
        }

        public PlayerLatency build() {
            return new PlayerLatency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlayerLatency> {
        public Builder playerId(String var1);

        public Builder regionIdentifier(String var1);

        public Builder latencyInMilliseconds(Float var1);
    }
}

