/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.ComparisonOperatorType;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.MetricName;
import software.amazon.awssdk.services.gamelift.model.PolicyType;
import software.amazon.awssdk.services.gamelift.model.ScalingAdjustmentType;
import software.amazon.awssdk.services.gamelift.model.TargetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutScalingPolicyRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, PutScalingPolicyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::name)).setter(PutScalingPolicyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::fleetId)).setter(PutScalingPolicyRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<Integer> SCALING_ADJUSTMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScalingAdjustment").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::scalingAdjustment)).setter(PutScalingPolicyRequest.setter(Builder::scalingAdjustment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustment").build()}).build();
    private static final SdkField<String> SCALING_ADJUSTMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScalingAdjustmentType").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::scalingAdjustmentTypeAsString)).setter(PutScalingPolicyRequest.setter(Builder::scalingAdjustmentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingAdjustmentType").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::threshold)).setter(PutScalingPolicyRequest.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::comparisonOperatorAsString)).setter(PutScalingPolicyRequest.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EvaluationPeriods").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::evaluationPeriods)).setter(PutScalingPolicyRequest.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationPeriods").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::metricNameAsString)).setter(PutScalingPolicyRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::policyTypeAsString)).setter(PutScalingPolicyRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetConfiguration").getter(PutScalingPolicyRequest.getter(PutScalingPolicyRequest::targetConfiguration)).setter(PutScalingPolicyRequest.setter(Builder::targetConfiguration)).constructor(TargetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FLEET_ID_FIELD, SCALING_ADJUSTMENT_FIELD, SCALING_ADJUSTMENT_TYPE_FIELD, THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD, EVALUATION_PERIODS_FIELD, METRIC_NAME_FIELD, POLICY_TYPE_FIELD, TARGET_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutScalingPolicyRequest.memberNameToFieldInitializer();
    private final String name;
    private final String fleetId;
    private final Integer scalingAdjustment;
    private final String scalingAdjustmentType;
    private final Double threshold;
    private final String comparisonOperator;
    private final Integer evaluationPeriods;
    private final String metricName;
    private final String policyType;
    private final TargetConfiguration targetConfiguration;

    private PutScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.fleetId = builder.fleetId;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.scalingAdjustmentType = builder.scalingAdjustmentType;
        this.threshold = builder.threshold;
        this.comparisonOperator = builder.comparisonOperator;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.metricName = builder.metricName;
        this.policyType = builder.policyType;
        this.targetConfiguration = builder.targetConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final Integer scalingAdjustment() {
        return this.scalingAdjustment;
    }

    public final ScalingAdjustmentType scalingAdjustmentType() {
        return ScalingAdjustmentType.fromValue(this.scalingAdjustmentType);
    }

    public final String scalingAdjustmentTypeAsString() {
        return this.scalingAdjustmentType;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final ComparisonOperatorType comparisonOperator() {
        return ComparisonOperatorType.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final TargetConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustment());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingAdjustmentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyRequest)) {
            return false;
        }
        PutScalingPolicyRequest other = (PutScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.scalingAdjustment(), other.scalingAdjustment()) && Objects.equals(this.scalingAdjustmentTypeAsString(), other.scalingAdjustmentTypeAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutScalingPolicyRequest").add("Name", (Object)this.name()).add("FleetId", (Object)this.fleetId()).add("ScalingAdjustment", (Object)this.scalingAdjustment()).add("ScalingAdjustmentType", (Object)this.scalingAdjustmentTypeAsString()).add("Threshold", (Object)this.threshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("MetricName", (Object)this.metricNameAsString()).add("PolicyType", (Object)this.policyTypeAsString()).add("TargetConfiguration", (Object)this.targetConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "ScalingAdjustment": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustment()));
            }
            case "ScalingAdjustmentType": {
                return Optional.ofNullable(clazz.cast(this.scalingAdjustmentTypeAsString()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "EvaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "TargetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("ScalingAdjustment", SCALING_ADJUSTMENT_FIELD);
        map.put("ScalingAdjustmentType", SCALING_ADJUSTMENT_TYPE_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        map.put("EvaluationPeriods", EVALUATION_PERIODS_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("PolicyType", POLICY_TYPE_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutScalingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String name;
        private String fleetId;
        private Integer scalingAdjustment;
        private String scalingAdjustmentType;
        private Double threshold;
        private String comparisonOperator;
        private Integer evaluationPeriods;
        private String metricName;
        private String policyType;
        private TargetConfiguration targetConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyRequest model) {
            super(model);
            this.name(model.name);
            this.fleetId(model.fleetId);
            this.scalingAdjustment(model.scalingAdjustment);
            this.scalingAdjustmentType(model.scalingAdjustmentType);
            this.threshold(model.threshold);
            this.comparisonOperator(model.comparisonOperator);
            this.evaluationPeriods(model.evaluationPeriods);
            this.metricName(model.metricName);
            this.policyType(model.policyType);
            this.targetConfiguration(model.targetConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final Integer getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final String getScalingAdjustmentType() {
            return this.scalingAdjustmentType;
        }

        public final void setScalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
        }

        @Override
        public final Builder scalingAdjustmentType(String scalingAdjustmentType) {
            this.scalingAdjustmentType = scalingAdjustmentType;
            return this;
        }

        @Override
        public final Builder scalingAdjustmentType(ScalingAdjustmentType scalingAdjustmentType) {
            this.scalingAdjustmentType(scalingAdjustmentType == null ? null : scalingAdjustmentType.toString());
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperatorType comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutScalingPolicyRequest build() {
            return new PutScalingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutScalingPolicyRequest> {
        public Builder name(String var1);

        public Builder fleetId(String var1);

        public Builder scalingAdjustment(Integer var1);

        public Builder scalingAdjustmentType(String var1);

        public Builder scalingAdjustmentType(ScalingAdjustmentType var1);

        public Builder threshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperatorType var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder targetConfiguration(TargetConfiguration var1);

        default public Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((TargetConfiguration)((TargetConfiguration.Builder)TargetConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

