/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.MatchedPlayerSession;
import software.amazon.awssdk.services.gamelift.model.MatchedPlayerSessionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameSessionConnectionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameSessionConnectionInfo> {
    private static final SdkField<String> GAME_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionArn").getter(GameSessionConnectionInfo.getter(GameSessionConnectionInfo::gameSessionArn)).setter(GameSessionConnectionInfo.setter(Builder::gameSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionArn").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(GameSessionConnectionInfo.getter(GameSessionConnectionInfo::ipAddress)).setter(GameSessionConnectionInfo.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(GameSessionConnectionInfo.getter(GameSessionConnectionInfo::dnsName)).setter(GameSessionConnectionInfo.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(GameSessionConnectionInfo.getter(GameSessionConnectionInfo::port)).setter(GameSessionConnectionInfo.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<List<MatchedPlayerSession>> MATCHED_PLAYER_SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchedPlayerSessions").getter(GameSessionConnectionInfo.getter(GameSessionConnectionInfo::matchedPlayerSessions)).setter(GameSessionConnectionInfo.setter(Builder::matchedPlayerSessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedPlayerSessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchedPlayerSession::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ARN_FIELD, IP_ADDRESS_FIELD, DNS_NAME_FIELD, PORT_FIELD, MATCHED_PLAYER_SESSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GameSessionConnectionInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gameSessionArn;
    private final String ipAddress;
    private final String dnsName;
    private final Integer port;
    private final List<MatchedPlayerSession> matchedPlayerSessions;

    private GameSessionConnectionInfo(BuilderImpl builder) {
        this.gameSessionArn = builder.gameSessionArn;
        this.ipAddress = builder.ipAddress;
        this.dnsName = builder.dnsName;
        this.port = builder.port;
        this.matchedPlayerSessions = builder.matchedPlayerSessions;
    }

    public final String gameSessionArn() {
        return this.gameSessionArn;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final Integer port() {
        return this.port;
    }

    public final boolean hasMatchedPlayerSessions() {
        return this.matchedPlayerSessions != null && !(this.matchedPlayerSessions instanceof SdkAutoConstructList);
    }

    public final List<MatchedPlayerSession> matchedPlayerSessions() {
        return this.matchedPlayerSessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchedPlayerSessions() ? this.matchedPlayerSessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionConnectionInfo)) {
            return false;
        }
        GameSessionConnectionInfo other = (GameSessionConnectionInfo)obj;
        return Objects.equals(this.gameSessionArn(), other.gameSessionArn()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.port(), other.port()) && this.hasMatchedPlayerSessions() == other.hasMatchedPlayerSessions() && Objects.equals(this.matchedPlayerSessions(), other.matchedPlayerSessions());
    }

    public final String toString() {
        return ToString.builder((String)"GameSessionConnectionInfo").add("GameSessionArn", (Object)this.gameSessionArn()).add("IpAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("DnsName", (Object)this.dnsName()).add("Port", (Object)this.port()).add("MatchedPlayerSessions", this.hasMatchedPlayerSessions() ? this.matchedPlayerSessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GameSessionArn": {
                return Optional.ofNullable(clazz.cast(this.gameSessionArn()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MatchedPlayerSessions": {
                return Optional.ofNullable(clazz.cast(this.matchedPlayerSessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GameSessionArn", GAME_SESSION_ARN_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MatchedPlayerSessions", MATCHED_PLAYER_SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GameSessionConnectionInfo, T> g) {
        return obj -> g.apply((GameSessionConnectionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gameSessionArn;
        private String ipAddress;
        private String dnsName;
        private Integer port;
        private List<MatchedPlayerSession> matchedPlayerSessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionConnectionInfo model) {
            this.gameSessionArn(model.gameSessionArn);
            this.ipAddress(model.ipAddress);
            this.dnsName(model.dnsName);
            this.port(model.port);
            this.matchedPlayerSessions(model.matchedPlayerSessions);
        }

        public final String getGameSessionArn() {
            return this.gameSessionArn;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final List<MatchedPlayerSession.Builder> getMatchedPlayerSessions() {
            List<MatchedPlayerSession.Builder> result = MatchedPlayerSessionListCopier.copyToBuilder(this.matchedPlayerSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchedPlayerSessions(Collection<MatchedPlayerSession.BuilderImpl> matchedPlayerSessions) {
            this.matchedPlayerSessions = MatchedPlayerSessionListCopier.copyFromBuilder(matchedPlayerSessions);
        }

        @Override
        public final Builder matchedPlayerSessions(Collection<MatchedPlayerSession> matchedPlayerSessions) {
            this.matchedPlayerSessions = MatchedPlayerSessionListCopier.copy(matchedPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedPlayerSessions(MatchedPlayerSession ... matchedPlayerSessions) {
            this.matchedPlayerSessions(Arrays.asList(matchedPlayerSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedPlayerSessions(Consumer<MatchedPlayerSession.Builder> ... matchedPlayerSessions) {
            this.matchedPlayerSessions(Stream.of(matchedPlayerSessions).map(c -> (MatchedPlayerSession)((MatchedPlayerSession.Builder)MatchedPlayerSession.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GameSessionConnectionInfo build() {
            return new GameSessionConnectionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameSessionConnectionInfo> {
        public Builder gameSessionArn(String var1);

        public Builder ipAddress(String var1);

        public Builder dnsName(String var1);

        public Builder port(Integer var1);

        public Builder matchedPlayerSessions(Collection<MatchedPlayerSession> var1);

        public Builder matchedPlayerSessions(MatchedPlayerSession ... var1);

        public Builder matchedPlayerSessions(Consumer<MatchedPlayerSession.Builder> ... var1);
    }
}

