/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpProtocol {
    TCP("TCP"),
    UDP("UDP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpProtocol> VALUE_MAP;
    private final String value;

    private IpProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpProtocol> knownValues() {
        EnumSet<IpProtocol> knownValues = EnumSet.allOf(IpProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpProtocol.class, IpProtocol::toString);
    }
}

