/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.GameServer;
import software.amazon.awssdk.services.gamelift.model.ListGameServersRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServersResponse;

public class ListGameServersIterable
implements SdkIterable<ListGameServersResponse> {
    private final GameLiftClient client;
    private final ListGameServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGameServersIterable(GameLiftClient client, ListGameServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListGameServersResponseFetcher();
    }

    public Iterator<ListGameServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameServer> gameServers() {
        Function<ListGameServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameServers() != null) {
                return response.gameServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGameServersResponseFetcher
    implements SyncPageFetcher<ListGameServersResponse> {
        private ListGameServersResponseFetcher() {
        }

        public boolean hasNextPage(ListGameServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGameServersResponse nextPage(ListGameServersResponse previousPage) {
            if (previousPage == null) {
                return ListGameServersIterable.this.client.listGameServers(ListGameServersIterable.this.firstRequest);
            }
            return ListGameServersIterable.this.client.listGameServers((ListGameServersRequest)((Object)ListGameServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

