/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.DeploymentConfiguration;
import software.amazon.awssdk.services.gamelift.model.DeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetDeployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(FleetDeployment.getter(FleetDeployment::deploymentId)).setter(FleetDeployment.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(FleetDeployment.getter(FleetDeployment::fleetId)).setter(FleetDeployment.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> GAME_SERVER_BINARY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameServerBinaryArn").getter(FleetDeployment.getter(FleetDeployment::gameServerBinaryArn)).setter(FleetDeployment.setter(Builder::gameServerBinaryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerBinaryArn").build()}).build();
    private static final SdkField<String> ROLLBACK_GAME_SERVER_BINARY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RollbackGameServerBinaryArn").getter(FleetDeployment.getter(FleetDeployment::rollbackGameServerBinaryArn)).setter(FleetDeployment.setter(Builder::rollbackGameServerBinaryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackGameServerBinaryArn").build()}).build();
    private static final SdkField<String> PER_INSTANCE_BINARY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerInstanceBinaryArn").getter(FleetDeployment.getter(FleetDeployment::perInstanceBinaryArn)).setter(FleetDeployment.setter(Builder::perInstanceBinaryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerInstanceBinaryArn").build()}).build();
    private static final SdkField<String> ROLLBACK_PER_INSTANCE_BINARY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RollbackPerInstanceBinaryArn").getter(FleetDeployment.getter(FleetDeployment::rollbackPerInstanceBinaryArn)).setter(FleetDeployment.setter(Builder::rollbackPerInstanceBinaryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackPerInstanceBinaryArn").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentStatus").getter(FleetDeployment.getter(FleetDeployment::deploymentStatusAsString)).setter(FleetDeployment.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStatus").build()}).build();
    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentConfiguration").getter(FleetDeployment.getter(FleetDeployment::deploymentConfiguration)).setter(FleetDeployment.setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfiguration").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FleetDeployment.getter(FleetDeployment::creationTime)).setter(FleetDeployment.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, FLEET_ID_FIELD, GAME_SERVER_BINARY_ARN_FIELD, ROLLBACK_GAME_SERVER_BINARY_ARN_FIELD, PER_INSTANCE_BINARY_ARN_FIELD, ROLLBACK_PER_INSTANCE_BINARY_ARN_FIELD, DEPLOYMENT_STATUS_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DeploymentId", DEPLOYMENT_ID_FIELD);
            this.put("FleetId", FLEET_ID_FIELD);
            this.put("GameServerBinaryArn", GAME_SERVER_BINARY_ARN_FIELD);
            this.put("RollbackGameServerBinaryArn", ROLLBACK_GAME_SERVER_BINARY_ARN_FIELD);
            this.put("PerInstanceBinaryArn", PER_INSTANCE_BINARY_ARN_FIELD);
            this.put("RollbackPerInstanceBinaryArn", ROLLBACK_PER_INSTANCE_BINARY_ARN_FIELD);
            this.put("DeploymentStatus", DEPLOYMENT_STATUS_FIELD);
            this.put("DeploymentConfiguration", DEPLOYMENT_CONFIGURATION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String fleetId;
    private final String gameServerBinaryArn;
    private final String rollbackGameServerBinaryArn;
    private final String perInstanceBinaryArn;
    private final String rollbackPerInstanceBinaryArn;
    private final String deploymentStatus;
    private final DeploymentConfiguration deploymentConfiguration;
    private final Instant creationTime;

    private FleetDeployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.fleetId = builder.fleetId;
        this.gameServerBinaryArn = builder.gameServerBinaryArn;
        this.rollbackGameServerBinaryArn = builder.rollbackGameServerBinaryArn;
        this.perInstanceBinaryArn = builder.perInstanceBinaryArn;
        this.rollbackPerInstanceBinaryArn = builder.rollbackPerInstanceBinaryArn;
        this.deploymentStatus = builder.deploymentStatus;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.creationTime = builder.creationTime;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String gameServerBinaryArn() {
        return this.gameServerBinaryArn;
    }

    public final String rollbackGameServerBinaryArn() {
        return this.rollbackGameServerBinaryArn;
    }

    public final String perInstanceBinaryArn() {
        return this.perInstanceBinaryArn;
    }

    public final String rollbackPerInstanceBinaryArn() {
        return this.rollbackPerInstanceBinaryArn;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameServerBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackGameServerBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.perInstanceBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackPerInstanceBinaryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetDeployment)) {
            return false;
        }
        FleetDeployment other = (FleetDeployment)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.gameServerBinaryArn(), other.gameServerBinaryArn()) && Objects.equals(this.rollbackGameServerBinaryArn(), other.rollbackGameServerBinaryArn()) && Objects.equals(this.perInstanceBinaryArn(), other.perInstanceBinaryArn()) && Objects.equals(this.rollbackPerInstanceBinaryArn(), other.rollbackPerInstanceBinaryArn()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.deploymentConfiguration(), other.deploymentConfiguration()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"FleetDeployment").add("DeploymentId", (Object)this.deploymentId()).add("FleetId", (Object)this.fleetId()).add("GameServerBinaryArn", (Object)this.gameServerBinaryArn()).add("RollbackGameServerBinaryArn", (Object)this.rollbackGameServerBinaryArn()).add("PerInstanceBinaryArn", (Object)this.perInstanceBinaryArn()).add("RollbackPerInstanceBinaryArn", (Object)this.rollbackPerInstanceBinaryArn()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("DeploymentConfiguration", (Object)this.deploymentConfiguration()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "GameServerBinaryArn": {
                return Optional.ofNullable(clazz.cast(this.gameServerBinaryArn()));
            }
            case "RollbackGameServerBinaryArn": {
                return Optional.ofNullable(clazz.cast(this.rollbackGameServerBinaryArn()));
            }
            case "PerInstanceBinaryArn": {
                return Optional.ofNullable(clazz.cast(this.perInstanceBinaryArn()));
            }
            case "RollbackPerInstanceBinaryArn": {
                return Optional.ofNullable(clazz.cast(this.rollbackPerInstanceBinaryArn()));
            }
            case "DeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "DeploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfiguration()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FleetDeployment, T> g) {
        return obj -> g.apply((FleetDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String fleetId;
        private String gameServerBinaryArn;
        private String rollbackGameServerBinaryArn;
        private String perInstanceBinaryArn;
        private String rollbackPerInstanceBinaryArn;
        private String deploymentStatus;
        private DeploymentConfiguration deploymentConfiguration;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetDeployment model) {
            this.deploymentId(model.deploymentId);
            this.fleetId(model.fleetId);
            this.gameServerBinaryArn(model.gameServerBinaryArn);
            this.rollbackGameServerBinaryArn(model.rollbackGameServerBinaryArn);
            this.perInstanceBinaryArn(model.perInstanceBinaryArn);
            this.rollbackPerInstanceBinaryArn(model.rollbackPerInstanceBinaryArn);
            this.deploymentStatus(model.deploymentStatus);
            this.deploymentConfiguration(model.deploymentConfiguration);
            this.creationTime(model.creationTime);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getGameServerBinaryArn() {
            return this.gameServerBinaryArn;
        }

        public final void setGameServerBinaryArn(String gameServerBinaryArn) {
            this.gameServerBinaryArn = gameServerBinaryArn;
        }

        @Override
        public final Builder gameServerBinaryArn(String gameServerBinaryArn) {
            this.gameServerBinaryArn = gameServerBinaryArn;
            return this;
        }

        public final String getRollbackGameServerBinaryArn() {
            return this.rollbackGameServerBinaryArn;
        }

        public final void setRollbackGameServerBinaryArn(String rollbackGameServerBinaryArn) {
            this.rollbackGameServerBinaryArn = rollbackGameServerBinaryArn;
        }

        @Override
        public final Builder rollbackGameServerBinaryArn(String rollbackGameServerBinaryArn) {
            this.rollbackGameServerBinaryArn = rollbackGameServerBinaryArn;
            return this;
        }

        public final String getPerInstanceBinaryArn() {
            return this.perInstanceBinaryArn;
        }

        public final void setPerInstanceBinaryArn(String perInstanceBinaryArn) {
            this.perInstanceBinaryArn = perInstanceBinaryArn;
        }

        @Override
        public final Builder perInstanceBinaryArn(String perInstanceBinaryArn) {
            this.perInstanceBinaryArn = perInstanceBinaryArn;
            return this;
        }

        public final String getRollbackPerInstanceBinaryArn() {
            return this.rollbackPerInstanceBinaryArn;
        }

        public final void setRollbackPerInstanceBinaryArn(String rollbackPerInstanceBinaryArn) {
            this.rollbackPerInstanceBinaryArn = rollbackPerInstanceBinaryArn;
        }

        @Override
        public final Builder rollbackPerInstanceBinaryArn(String rollbackPerInstanceBinaryArn) {
            this.rollbackPerInstanceBinaryArn = rollbackPerInstanceBinaryArn;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return this.deploymentConfiguration != null ? this.deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public FleetDeployment build() {
            return new FleetDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetDeployment> {
        public Builder deploymentId(String var1);

        public Builder fleetId(String var1);

        public Builder gameServerBinaryArn(String var1);

        public Builder rollbackGameServerBinaryArn(String var1);

        public Builder perInstanceBinaryArn(String var1);

        public Builder rollbackPerInstanceBinaryArn(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder deploymentConfiguration(DeploymentConfiguration var1);

        default public Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return this.deploymentConfiguration((DeploymentConfiguration)((DeploymentConfiguration.Builder)DeploymentConfiguration.builder().applyMutation(deploymentConfiguration)).build());
        }

        public Builder creationTime(Instant var1);
    }
}

