/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.Credentials;
import software.amazon.awssdk.services.gamelift.model.GameLiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComputeAccessResponse
extends GameLiftResponse
implements ToCopyableBuilder<Builder, GetComputeAccessResponse> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(GetComputeAccessResponse.getter(GetComputeAccessResponse::fleetId)).setter(GetComputeAccessResponse.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(GetComputeAccessResponse.getter(GetComputeAccessResponse::fleetArn)).setter(GetComputeAccessResponse.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> COMPUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeName").getter(GetComputeAccessResponse.getter(GetComputeAccessResponse::computeName)).setter(GetComputeAccessResponse.setter(Builder::computeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeName").build()}).build();
    private static final SdkField<String> COMPUTE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeArn").getter(GetComputeAccessResponse.getter(GetComputeAccessResponse::computeArn)).setter(GetComputeAccessResponse.setter(Builder::computeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeArn").build()}).build();
    private static final SdkField<Credentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(GetComputeAccessResponse.getter(GetComputeAccessResponse::credentials)).setter(GetComputeAccessResponse.setter(Builder::credentials)).constructor(Credentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(GetComputeAccessResponse.getter(GetComputeAccessResponse::target)).setter(GetComputeAccessResponse.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, FLEET_ARN_FIELD, COMPUTE_NAME_FIELD, COMPUTE_ARN_FIELD, CREDENTIALS_FIELD, TARGET_FIELD));
    private final String fleetId;
    private final String fleetArn;
    private final String computeName;
    private final String computeArn;
    private final Credentials credentials;
    private final String target;

    private GetComputeAccessResponse(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.fleetArn = builder.fleetArn;
        this.computeName = builder.computeName;
        this.computeArn = builder.computeArn;
        this.credentials = builder.credentials;
        this.target = builder.target;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String computeName() {
        return this.computeName;
    }

    public final String computeArn() {
        return this.computeArn;
    }

    public final Credentials credentials() {
        return this.credentials;
    }

    public final String target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComputeAccessResponse)) {
            return false;
        }
        GetComputeAccessResponse other = (GetComputeAccessResponse)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.computeName(), other.computeName()) && Objects.equals(this.computeArn(), other.computeArn()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"GetComputeAccessResponse").add("FleetId", (Object)this.fleetId()).add("FleetArn", (Object)this.fleetArn()).add("ComputeName", (Object)this.computeName()).add("ComputeArn", (Object)this.computeArn()).add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "ComputeName": {
                return Optional.ofNullable(clazz.cast(this.computeName()));
            }
            case "ComputeArn": {
                return Optional.ofNullable(clazz.cast(this.computeArn()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComputeAccessResponse, T> g) {
        return obj -> g.apply((GetComputeAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftResponse.BuilderImpl
    implements Builder {
        private String fleetId;
        private String fleetArn;
        private String computeName;
        private String computeArn;
        private Credentials credentials;
        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComputeAccessResponse model) {
            super(model);
            this.fleetId(model.fleetId);
            this.fleetArn(model.fleetArn);
            this.computeName(model.computeName);
            this.computeArn(model.computeArn);
            this.credentials(model.credentials);
            this.target(model.target);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getComputeName() {
            return this.computeName;
        }

        public final void setComputeName(String computeName) {
            this.computeName = computeName;
        }

        @Override
        public final Builder computeName(String computeName) {
            this.computeName = computeName;
            return this;
        }

        public final String getComputeArn() {
            return this.computeArn;
        }

        public final void setComputeArn(String computeArn) {
            this.computeArn = computeArn;
        }

        @Override
        public final Builder computeArn(String computeArn) {
            this.computeArn = computeArn;
            return this;
        }

        public final Credentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(Credentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public GetComputeAccessResponse build() {
            return new GetComputeAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComputeAccessResponse> {
        public Builder fleetId(String var1);

        public Builder fleetArn(String var1);

        public Builder computeName(String var1);

        public Builder computeArn(String var1);

        public Builder credentials(Credentials var1);

        default public Builder credentials(Consumer<Credentials.Builder> credentials) {
            return this.credentials((Credentials)((Credentials.Builder)Credentials.builder().applyMutation(credentials)).build());
        }

        public Builder target(String var1);
    }
}

