/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GameServerHealthCheck {
    HEALTHY("HEALTHY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GameServerHealthCheck> VALUE_MAP;
    private final String value;

    private GameServerHealthCheck(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GameServerHealthCheck fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GameServerHealthCheck> knownValues() {
        EnumSet<GameServerHealthCheck> knownValues = EnumSet.allOf(GameServerHealthCheck.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GameServerHealthCheck.class, GameServerHealthCheck::toString);
    }
}

