/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.ListScriptsRequest;
import software.amazon.awssdk.services.gamelift.model.ListScriptsResponse;
import software.amazon.awssdk.services.gamelift.model.Script;

public class ListScriptsPublisher
implements SdkPublisher<ListScriptsResponse> {
    private final GameLiftAsyncClient client;
    private final ListScriptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScriptsPublisher(GameLiftAsyncClient client, ListScriptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScriptsPublisher(GameLiftAsyncClient client, ListScriptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScriptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScriptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Script> scripts() {
        Function<ListScriptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scripts() != null) {
                return response.scripts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScriptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScriptsResponseFetcher
    implements AsyncPageFetcher<ListScriptsResponse> {
        private ListScriptsResponseFetcher() {
        }

        public boolean hasNextPage(ListScriptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScriptsResponse> nextPage(ListScriptsResponse previousPage) {
            if (previousPage == null) {
                return ListScriptsPublisher.this.client.listScripts(ListScriptsPublisher.this.firstRequest);
            }
            return ListScriptsPublisher.this.client.listScripts((ListScriptsRequest)((Object)ListScriptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

