/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.GameProperty;
import software.amazon.awssdk.services.gamelift.model.GamePropertyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGameSessionRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateGameSessionRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::fleetId)).setter(CreateGameSessionRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AliasId").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::aliasId)).setter(CreateGameSessionRequest.setter(Builder::aliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()}).build();
    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::maximumPlayerSessionCount)).setter(CreateGameSessionRequest.setter(Builder::maximumPlayerSessionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::name)).setter(CreateGameSessionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GameProperties").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::gameProperties)).setter(CreateGameSessionRequest.setter(Builder::gameProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorId").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::creatorId)).setter(CreateGameSessionRequest.setter(Builder::creatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()}).build();
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionId").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::gameSessionId)).setter(CreateGameSessionRequest.setter(Builder::gameSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::idempotencyToken)).setter(CreateGameSessionRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionData").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::gameSessionData)).setter(CreateGameSessionRequest.setter(Builder::gameSessionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateGameSessionRequest.getter(CreateGameSessionRequest::location)).setter(CreateGameSessionRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, ALIAS_ID_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, NAME_FIELD, GAME_PROPERTIES_FIELD, CREATOR_ID_FIELD, GAME_SESSION_ID_FIELD, IDEMPOTENCY_TOKEN_FIELD, GAME_SESSION_DATA_FIELD, LOCATION_FIELD));
    private final String fleetId;
    private final String aliasId;
    private final Integer maximumPlayerSessionCount;
    private final String name;
    private final List<GameProperty> gameProperties;
    private final String creatorId;
    private final String gameSessionId;
    private final String idempotencyToken;
    private final String gameSessionData;
    private final String location;

    private CreateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.gameProperties = builder.gameProperties;
        this.creatorId = builder.creatorId;
        this.gameSessionId = builder.gameSessionId;
        this.idempotencyToken = builder.idempotencyToken;
        this.gameSessionData = builder.gameSessionData;
        this.location = builder.location;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String aliasId() {
        return this.aliasId;
    }

    public final Integer maximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasGameProperties() {
        return this.gameProperties != null && !(this.gameProperties instanceof SdkAutoConstructList);
    }

    public final List<GameProperty> gameProperties() {
        return this.gameProperties;
    }

    public final String creatorId() {
        return this.creatorId;
    }

    public final String gameSessionId() {
        return this.gameSessionId;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final String gameSessionData() {
        return this.gameSessionData;
    }

    public final String location() {
        return this.location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGameProperties() ? this.gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionRequest)) {
            return false;
        }
        CreateGameSessionRequest other = (CreateGameSessionRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.aliasId(), other.aliasId()) && Objects.equals(this.maximumPlayerSessionCount(), other.maximumPlayerSessionCount()) && Objects.equals(this.name(), other.name()) && this.hasGameProperties() == other.hasGameProperties() && Objects.equals(this.gameProperties(), other.gameProperties()) && Objects.equals(this.creatorId(), other.creatorId()) && Objects.equals(this.gameSessionId(), other.gameSessionId()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.gameSessionData(), other.gameSessionData()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGameSessionRequest").add("FleetId", (Object)this.fleetId()).add("AliasId", (Object)this.aliasId()).add("MaximumPlayerSessionCount", (Object)this.maximumPlayerSessionCount()).add("Name", (Object)this.name()).add("GameProperties", this.hasGameProperties() ? this.gameProperties() : null).add("CreatorId", (Object)this.creatorId()).add("GameSessionId", (Object)this.gameSessionId()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("GameSessionData", (Object)this.gameSessionData()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "AliasId": {
                return Optional.ofNullable(clazz.cast(this.aliasId()));
            }
            case "MaximumPlayerSessionCount": {
                return Optional.ofNullable(clazz.cast(this.maximumPlayerSessionCount()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "GameProperties": {
                return Optional.ofNullable(clazz.cast(this.gameProperties()));
            }
            case "CreatorId": {
                return Optional.ofNullable(clazz.cast(this.creatorId()));
            }
            case "GameSessionId": {
                return Optional.ofNullable(clazz.cast(this.gameSessionId()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "GameSessionData": {
                return Optional.ofNullable(clazz.cast(this.gameSessionData()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGameSessionRequest, T> g) {
        return obj -> g.apply((CreateGameSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String aliasId;
        private Integer maximumPlayerSessionCount;
        private String name;
        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();
        private String creatorId;
        private String gameSessionId;
        private String idempotencyToken;
        private String gameSessionData;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameSessionRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.aliasId(model.aliasId);
            this.maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            this.name(model.name);
            this.gameProperties(model.gameProperties);
            this.creatorId(model.creatorId);
            this.gameSessionId(model.gameSessionId);
            this.idempotencyToken(model.idempotencyToken);
            this.gameSessionData(model.gameSessionData);
            this.location(model.location);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getAliasId() {
            return this.aliasId;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return this.maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty ... gameProperties) {
            this.gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder> ... gameProperties) {
            this.gameProperties(Stream.of(gameProperties).map(c -> (GameProperty)((GameProperty.Builder)GameProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCreatorId() {
            return this.creatorId;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final String getGameSessionId() {
            return this.gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getGameSessionData() {
            return this.gameSessionData;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameSessionRequest build() {
            return new CreateGameSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGameSessionRequest> {
        public Builder fleetId(String var1);

        public Builder aliasId(String var1);

        public Builder maximumPlayerSessionCount(Integer var1);

        public Builder name(String var1);

        public Builder gameProperties(Collection<GameProperty> var1);

        public Builder gameProperties(GameProperty ... var1);

        public Builder gameProperties(Consumer<GameProperty.Builder> ... var1);

        public Builder creatorId(String var1);

        public Builder gameSessionId(String var1);

        public Builder idempotencyToken(String var1);

        public Builder gameSessionData(String var1);

        public Builder location(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

