/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.Build;
import software.amazon.awssdk.services.gamelift.model.ListBuildsRequest;
import software.amazon.awssdk.services.gamelift.model.ListBuildsResponse;

public class ListBuildsPublisher
implements SdkPublisher<ListBuildsResponse> {
    private final GameLiftAsyncClient client;
    private final ListBuildsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBuildsPublisher(GameLiftAsyncClient client, ListBuildsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBuildsPublisher(GameLiftAsyncClient client, ListBuildsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBuildsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBuildsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Build> builds() {
        Function<ListBuildsResponse, Iterator> getIterator = response -> {
            if (response != null && response.builds() != null) {
                return response.builds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBuildsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBuildsResponseFetcher
    implements AsyncPageFetcher<ListBuildsResponse> {
        private ListBuildsResponseFetcher() {
        }

        public boolean hasNextPage(ListBuildsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBuildsResponse> nextPage(ListBuildsResponse previousPage) {
            if (previousPage == null) {
                return ListBuildsPublisher.this.client.listBuilds(ListBuildsPublisher.this.firstRequest);
            }
            return ListBuildsPublisher.this.client.listBuilds((ListBuildsRequest)((Object)ListBuildsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

