/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.FilterConfiguration;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestination;
import software.amazon.awssdk.services.gamelift.model.GameSessionQueueDestinationListCopier;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicy;
import software.amazon.awssdk.services.gamelift.model.PlayerLatencyPolicyListCopier;
import software.amazon.awssdk.services.gamelift.model.PriorityConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GameSessionQueue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GameSessionQueue> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GameSessionQueue.getter(GameSessionQueue::name)).setter(GameSessionQueue.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> GAME_SESSION_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GameSessionQueueArn").getter(GameSessionQueue.getter(GameSessionQueue::gameSessionQueueArn)).setter(GameSessionQueue.setter(Builder::gameSessionQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueArn").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeoutInSeconds").getter(GameSessionQueue.getter(GameSessionQueue::timeoutInSeconds)).setter(GameSessionQueue.setter(Builder::timeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutInSeconds").build()}).build();
    private static final SdkField<List<PlayerLatencyPolicy>> PLAYER_LATENCY_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlayerLatencyPolicies").getter(GameSessionQueue.getter(GameSessionQueue::playerLatencyPolicies)).setter(GameSessionQueue.setter(Builder::playerLatencyPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerLatencyPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlayerLatencyPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GameSessionQueueDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(GameSessionQueue.getter(GameSessionQueue::destinations)).setter(GameSessionQueue.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GameSessionQueueDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FilterConfiguration> FILTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterConfiguration").getter(GameSessionQueue.getter(GameSessionQueue::filterConfiguration)).setter(GameSessionQueue.setter(Builder::filterConfiguration)).constructor(FilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConfiguration").build()}).build();
    private static final SdkField<PriorityConfiguration> PRIORITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PriorityConfiguration").getter(GameSessionQueue.getter(GameSessionQueue::priorityConfiguration)).setter(GameSessionQueue.setter(Builder::priorityConfiguration)).constructor(PriorityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorityConfiguration").build()}).build();
    private static final SdkField<String> CUSTOM_EVENT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomEventData").getter(GameSessionQueue.getter(GameSessionQueue::customEventData)).setter(GameSessionQueue.setter(Builder::customEventData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEventData").build()}).build();
    private static final SdkField<String> NOTIFICATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationTarget").getter(GameSessionQueue.getter(GameSessionQueue::notificationTarget)).setter(GameSessionQueue.setter(Builder::notificationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, GAME_SESSION_QUEUE_ARN_FIELD, TIMEOUT_IN_SECONDS_FIELD, PLAYER_LATENCY_POLICIES_FIELD, DESTINATIONS_FIELD, FILTER_CONFIGURATION_FIELD, PRIORITY_CONFIGURATION_FIELD, CUSTOM_EVENT_DATA_FIELD, NOTIFICATION_TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String gameSessionQueueArn;
    private final Integer timeoutInSeconds;
    private final List<PlayerLatencyPolicy> playerLatencyPolicies;
    private final List<GameSessionQueueDestination> destinations;
    private final FilterConfiguration filterConfiguration;
    private final PriorityConfiguration priorityConfiguration;
    private final String customEventData;
    private final String notificationTarget;

    private GameSessionQueue(BuilderImpl builder) {
        this.name = builder.name;
        this.gameSessionQueueArn = builder.gameSessionQueueArn;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.playerLatencyPolicies = builder.playerLatencyPolicies;
        this.destinations = builder.destinations;
        this.filterConfiguration = builder.filterConfiguration;
        this.priorityConfiguration = builder.priorityConfiguration;
        this.customEventData = builder.customEventData;
        this.notificationTarget = builder.notificationTarget;
    }

    public final String name() {
        return this.name;
    }

    public final String gameSessionQueueArn() {
        return this.gameSessionQueueArn;
    }

    public final Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public final boolean hasPlayerLatencyPolicies() {
        return this.playerLatencyPolicies != null && !(this.playerLatencyPolicies instanceof SdkAutoConstructList);
    }

    public final List<PlayerLatencyPolicy> playerLatencyPolicies() {
        return this.playerLatencyPolicies;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<GameSessionQueueDestination> destinations() {
        return this.destinations;
    }

    public final FilterConfiguration filterConfiguration() {
        return this.filterConfiguration;
    }

    public final PriorityConfiguration priorityConfiguration() {
        return this.priorityConfiguration;
    }

    public final String customEventData() {
        return this.customEventData;
    }

    public final String notificationTarget() {
        return this.notificationTarget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.gameSessionQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlayerLatencyPolicies() ? this.playerLatencyPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.priorityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.customEventData());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSessionQueue)) {
            return false;
        }
        GameSessionQueue other = (GameSessionQueue)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.gameSessionQueueArn(), other.gameSessionQueueArn()) && Objects.equals(this.timeoutInSeconds(), other.timeoutInSeconds()) && this.hasPlayerLatencyPolicies() == other.hasPlayerLatencyPolicies() && Objects.equals(this.playerLatencyPolicies(), other.playerLatencyPolicies()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.filterConfiguration(), other.filterConfiguration()) && Objects.equals(this.priorityConfiguration(), other.priorityConfiguration()) && Objects.equals(this.customEventData(), other.customEventData()) && Objects.equals(this.notificationTarget(), other.notificationTarget());
    }

    public final String toString() {
        return ToString.builder((String)"GameSessionQueue").add("Name", (Object)this.name()).add("GameSessionQueueArn", (Object)this.gameSessionQueueArn()).add("TimeoutInSeconds", (Object)this.timeoutInSeconds()).add("PlayerLatencyPolicies", this.hasPlayerLatencyPolicies() ? this.playerLatencyPolicies() : null).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("FilterConfiguration", (Object)this.filterConfiguration()).add("PriorityConfiguration", (Object)this.priorityConfiguration()).add("CustomEventData", (Object)this.customEventData()).add("NotificationTarget", (Object)this.notificationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "GameSessionQueueArn": {
                return Optional.ofNullable(clazz.cast(this.gameSessionQueueArn()));
            }
            case "TimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutInSeconds()));
            }
            case "PlayerLatencyPolicies": {
                return Optional.ofNullable(clazz.cast(this.playerLatencyPolicies()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "FilterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.filterConfiguration()));
            }
            case "PriorityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.priorityConfiguration()));
            }
            case "CustomEventData": {
                return Optional.ofNullable(clazz.cast(this.customEventData()));
            }
            case "NotificationTarget": {
                return Optional.ofNullable(clazz.cast(this.notificationTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GameSessionQueue, T> g) {
        return obj -> g.apply((GameSessionQueue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String gameSessionQueueArn;
        private Integer timeoutInSeconds;
        private List<PlayerLatencyPolicy> playerLatencyPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<GameSessionQueueDestination> destinations = DefaultSdkAutoConstructList.getInstance();
        private FilterConfiguration filterConfiguration;
        private PriorityConfiguration priorityConfiguration;
        private String customEventData;
        private String notificationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(GameSessionQueue model) {
            this.name(model.name);
            this.gameSessionQueueArn(model.gameSessionQueueArn);
            this.timeoutInSeconds(model.timeoutInSeconds);
            this.playerLatencyPolicies(model.playerLatencyPolicies);
            this.destinations(model.destinations);
            this.filterConfiguration(model.filterConfiguration);
            this.priorityConfiguration(model.priorityConfiguration);
            this.customEventData(model.customEventData);
            this.notificationTarget(model.notificationTarget);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getGameSessionQueueArn() {
            return this.gameSessionQueueArn;
        }

        public final void setGameSessionQueueArn(String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
        }

        @Override
        public final Builder gameSessionQueueArn(String gameSessionQueueArn) {
            this.gameSessionQueueArn = gameSessionQueueArn;
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final List<PlayerLatencyPolicy.Builder> getPlayerLatencyPolicies() {
            List<PlayerLatencyPolicy.Builder> result = PlayerLatencyPolicyListCopier.copyToBuilder(this.playerLatencyPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlayerLatencyPolicies(Collection<PlayerLatencyPolicy.BuilderImpl> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copyFromBuilder(playerLatencyPolicies);
        }

        @Override
        public final Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> playerLatencyPolicies) {
            this.playerLatencyPolicies = PlayerLatencyPolicyListCopier.copy(playerLatencyPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(PlayerLatencyPolicy ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Arrays.asList(playerLatencyPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencyPolicies(Consumer<PlayerLatencyPolicy.Builder> ... playerLatencyPolicies) {
            this.playerLatencyPolicies(Stream.of(playerLatencyPolicies).map(c -> (PlayerLatencyPolicy)((PlayerLatencyPolicy.Builder)PlayerLatencyPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GameSessionQueueDestination.Builder> getDestinations() {
            List<GameSessionQueueDestination.Builder> result = GameSessionQueueDestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<GameSessionQueueDestination.BuilderImpl> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<GameSessionQueueDestination> destinations) {
            this.destinations = GameSessionQueueDestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(GameSessionQueueDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<GameSessionQueueDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (GameSessionQueueDestination)((GameSessionQueueDestination.Builder)GameSessionQueueDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FilterConfiguration.Builder getFilterConfiguration() {
            return this.filterConfiguration != null ? this.filterConfiguration.toBuilder() : null;
        }

        public final void setFilterConfiguration(FilterConfiguration.BuilderImpl filterConfiguration) {
            this.filterConfiguration = filterConfiguration != null ? filterConfiguration.build() : null;
        }

        @Override
        public final Builder filterConfiguration(FilterConfiguration filterConfiguration) {
            this.filterConfiguration = filterConfiguration;
            return this;
        }

        public final PriorityConfiguration.Builder getPriorityConfiguration() {
            return this.priorityConfiguration != null ? this.priorityConfiguration.toBuilder() : null;
        }

        public final void setPriorityConfiguration(PriorityConfiguration.BuilderImpl priorityConfiguration) {
            this.priorityConfiguration = priorityConfiguration != null ? priorityConfiguration.build() : null;
        }

        @Override
        public final Builder priorityConfiguration(PriorityConfiguration priorityConfiguration) {
            this.priorityConfiguration = priorityConfiguration;
            return this;
        }

        public final String getCustomEventData() {
            return this.customEventData;
        }

        public final void setCustomEventData(String customEventData) {
            this.customEventData = customEventData;
        }

        @Override
        public final Builder customEventData(String customEventData) {
            this.customEventData = customEventData;
            return this;
        }

        public final String getNotificationTarget() {
            return this.notificationTarget;
        }

        public final void setNotificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
        }

        @Override
        public final Builder notificationTarget(String notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        public GameSessionQueue build() {
            return new GameSessionQueue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GameSessionQueue> {
        public Builder name(String var1);

        public Builder gameSessionQueueArn(String var1);

        public Builder timeoutInSeconds(Integer var1);

        public Builder playerLatencyPolicies(Collection<PlayerLatencyPolicy> var1);

        public Builder playerLatencyPolicies(PlayerLatencyPolicy ... var1);

        public Builder playerLatencyPolicies(Consumer<PlayerLatencyPolicy.Builder> ... var1);

        public Builder destinations(Collection<GameSessionQueueDestination> var1);

        public Builder destinations(GameSessionQueueDestination ... var1);

        public Builder destinations(Consumer<GameSessionQueueDestination.Builder> ... var1);

        public Builder filterConfiguration(FilterConfiguration var1);

        default public Builder filterConfiguration(Consumer<FilterConfiguration.Builder> filterConfiguration) {
            return this.filterConfiguration((FilterConfiguration)((FilterConfiguration.Builder)FilterConfiguration.builder().applyMutation(filterConfiguration)).build());
        }

        public Builder priorityConfiguration(PriorityConfiguration var1);

        default public Builder priorityConfiguration(Consumer<PriorityConfiguration.Builder> priorityConfiguration) {
            return this.priorityConfiguration((PriorityConfiguration)((PriorityConfiguration.Builder)PriorityConfiguration.builder().applyMutation(priorityConfiguration)).build());
        }

        public Builder customEventData(String var1);

        public Builder notificationTarget(String var1);
    }
}

