/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.GameServerGroup;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse;

public class ListGameServerGroupsPublisher
implements SdkPublisher<ListGameServerGroupsResponse> {
    private final GameLiftAsyncClient client;
    private final ListGameServerGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGameServerGroupsPublisher(GameLiftAsyncClient client, ListGameServerGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGameServerGroupsPublisher(GameLiftAsyncClient client, ListGameServerGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGameServerGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGameServerGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameServerGroup> gameServerGroups() {
        Function<ListGameServerGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameServerGroups() != null) {
                return response.gameServerGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGameServerGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGameServerGroupsResponseFetcher
    implements AsyncPageFetcher<ListGameServerGroupsResponse> {
        private ListGameServerGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGameServerGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGameServerGroupsResponse> nextPage(ListGameServerGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGameServerGroupsPublisher.this.client.listGameServerGroups(ListGameServerGroupsPublisher.this.firstRequest);
            }
            return ListGameServerGroupsPublisher.this.client.listGameServerGroups((ListGameServerGroupsRequest)((Object)ListGameServerGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

