/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.Event;

public class DescribeFleetEventsPublisher
implements SdkPublisher<DescribeFleetEventsResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeFleetEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetEventsPublisher(GameLiftAsyncClient client, DescribeFleetEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetEventsPublisher(GameLiftAsyncClient client, DescribeFleetEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Event> events() {
        Function<DescribeFleetEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFleetEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFleetEventsResponseFetcher
    implements AsyncPageFetcher<DescribeFleetEventsResponse> {
        private DescribeFleetEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetEventsResponse> nextPage(DescribeFleetEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetEventsPublisher.this.client.describeFleetEvents(DescribeFleetEventsPublisher.this.firstRequest);
            }
            return DescribeFleetEventsPublisher.this.client.describeFleetEvents((DescribeFleetEventsRequest)((Object)DescribeFleetEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

