/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GameSessionStatus {
    ACTIVE("ACTIVE"),
    ACTIVATING("ACTIVATING"),
    TERMINATED("TERMINATED"),
    TERMINATING("TERMINATING"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GameSessionStatus> VALUE_MAP;
    private final String value;

    private GameSessionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GameSessionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GameSessionStatus> knownValues() {
        EnumSet<GameSessionStatus> knownValues = EnumSet.allOf(GameSessionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GameSessionStatus.class, GameSessionStatus::toString);
    }
}

