/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.GameSessionDetail;

public class DescribeGameSessionDetailsIterable
implements SdkIterable<DescribeGameSessionDetailsResponse> {
    private final GameLiftClient client;
    private final DescribeGameSessionDetailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGameSessionDetailsIterable(GameLiftClient client, DescribeGameSessionDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeGameSessionDetailsResponseFetcher();
    }

    public Iterator<DescribeGameSessionDetailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameSessionDetail> gameSessionDetails() {
        Function<DescribeGameSessionDetailsResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameSessionDetails() != null) {
                return response.gameSessionDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGameSessionDetailsResponseFetcher
    implements SyncPageFetcher<DescribeGameSessionDetailsResponse> {
        private DescribeGameSessionDetailsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameSessionDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeGameSessionDetailsResponse nextPage(DescribeGameSessionDetailsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameSessionDetailsIterable.this.client.describeGameSessionDetails(DescribeGameSessionDetailsIterable.this.firstRequest);
            }
            return DescribeGameSessionDetailsIterable.this.client.describeGameSessionDetails((DescribeGameSessionDetailsRequest)((Object)DescribeGameSessionDetailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

